package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 终端信息
 */
@ApiModel(description = "终端信息")

@Data
@JsonInclude(NON_NULL)
public class MsTerminalQueryResponseInfo implements Serializable {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("deviceId")
  private Long deviceId = null;

  @JsonProperty("deviceUn")
  private String deviceUn;

  @JsonProperty("terminalUn")
  private String terminalUn;

  @JsonProperty("companyInfo")
  private MsCompanyInfo companyInfo = null;

  @JsonProperty("operateInfo")
  private MsOperateInfo operateInfo = null;

  @JsonProperty("terminalNo")
  private String terminalNo = null;

  @JsonProperty("terminalName")
  private String terminalName = null;

  @JsonProperty("terminalType")
  private Integer terminalType = null;

  @JsonProperty("invoiceType")
  private List<String> invoiceType = new ArrayList<String>();

  @JsonProperty("supportService")
  private List<String> supportService = new ArrayList<String>();

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("paddingLeft")
  private Integer paddingLeft = null;

  @JsonProperty("paddingTop")
  private Integer paddingTop = null;

  @JsonProperty("printInvoiceTerminalId")
  private Long printInvoiceTerminalId = null;

  @JsonProperty("printSaleListTerminalId")
  private Long printSaleListTerminalId = null;

  @JsonProperty("onlineFlag")
  private Boolean onlineFlag = null;

  @JsonProperty("directOnlineFlag")
  private Integer directOnlineFlag = null;

  @JsonProperty("printerOnlineFlag")
  private Integer printerOnlineFlag = null;

  @JsonProperty("onlineDevice")
  private MsTerminalOnlineDeviceInfo onlineDevice;

  @JsonProperty("inventorys")
  private List<Inventory> inventorys ;

  private Integer taxDeviceType;

  private String taxDeviceMachineNo;

  private String deviceNo;

  /**
   * 部署类型 3-国信
   */
  private Integer deployType;

}
