package com.xforceplus.seller.config.client.model;

import java.io.Serializable;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsUpdateDeviceStatusResponse
 */

@JsonInclude(NON_NULL)
public class MsUpdateDeviceStatusResponse implements Serializable {
  @JsonProperty("head")
  private MsResponseHead head = null;

  @JsonIgnore
  public MsUpdateDeviceStatusResponse head(MsResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 设备状态更新
   * @return head
  **/
  @ApiModelProperty(value = "设备状态更新")
  public MsResponseHead getHead() {
    return head;
  }

  public void setHead(MsResponseHead head) {
    this.head = head;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsUpdateDeviceStatusResponse updateDeviceStatusResponse = (MsUpdateDeviceStatusResponse) o;
    return Objects.equals(this.head, updateDeviceStatusResponse.head);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsUpdateDeviceStatusResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
