package com.xforceplus.seller.config.client.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

@Data
public class NewMergeRuleAdapterDto implements Serializable {
    @ApiModelProperty("租户id")
    private Long groupId;
    @ApiModelProperty("一定有大于等于1个元素")
    private List<BillTypeTaxNoDto> billTypeTaxNoDtoList;


    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class BillTypeTaxNoDto {
        @ApiModelProperty("使用新引擎的业务单类型,为*则表示所有业务单类型")
        private String billType;
        @ApiModelProperty("模式")
        private String mode;
        @ApiModelProperty("业务单类型下试点税号列表，当其为空时，表示该租户整个业务单类型试点；不为空，则按指定税号试点")
        private List<String> taxNoList;
    }
}
