package com.xforceplus.seller.config.client.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class RedConfirmMatchStrategyDto implements Serializable {
    @ApiModelProperty("字段名")
    private String field;
    @ApiModelProperty("字段展示名")
    private String fieldDisplayName;
    @ApiModelProperty("字段类型")
    private String type;
    @ApiModelProperty("支持的操作符")
    private List<String> opList;
    @ApiModelProperty("枚举值（仅当type为e时有值）")
    private List<MatchEnum> enumList;
    @ApiModelProperty("时间选择范围（仅当type为m、t时有值）。固定为2个值，第一个表示最远值，第二个表示最近值")
    private List<Integer> timeRange;
    @ApiModelProperty("月份格式（仅当type为m时有值）")
    private String monthPattern;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class MatchEnum {
        private String code;
        private String text;
    }
}
