package com.xforceplus.seller.config.client.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * Describe: 入驻配置详情
 *
 * @Author xiezhongyong
 * @Date 2023-11-22
 */
@Data
public class SettledConfigResult {
    @ApiModelProperty("数据ID")
    private Long id;

    @ApiModelProperty("入驻记录主键")
    private Long settledObjId;

    @ApiModelProperty("配置类型;0-通用配置 1-定制配置")
    private Integer configType;

    @ApiModelProperty("配置代码")
    private String configCode;

    @ApiModelProperty("配置分类")
    private String configClass;

    @ApiModelProperty("入驻类型")
    private Integer settledType;

    @ApiModelProperty("入驻租户id")
    private Long tenantId;

    @ApiModelProperty("入驻租户名称")
    private String tenantName;

    @ApiModelProperty("产品代码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("单据类型")
    private String salesbillType;

    @ApiModelProperty("关联单据类型")
    private List<String> refSalesbillList;

    @ApiModelProperty("单据是否支持零售;0-非零售 1-零售")
    private Integer toCFlag;

    @ApiModelProperty("入驻描述")
    private String settledDesc;

    @ApiModelProperty("创建人id")
    private Long createUserId;

    @ApiModelProperty("创建人名称")
    private String createUserName;

    @ApiModelProperty("更新人id")
    private Long updateUserId;

    @ApiModelProperty("更新人名称")
    private String updateUserName;
}