package com.xforceplus.seller.config.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@ApiModel("编辑模版规则(选默认规则-删除、修改配置项-编辑、关闭开关-删除、开启开关-新增）")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SettledTemplateEditRequest {
    @ApiModelProperty("更新模版规则主信息")
    private UpdateTemplateInfo updateTemplateInfo;

    @ApiModelProperty("待删入驻记录下的模版信息")
    private DeleteTemplateInfo deleteTemplateInfo;

    @ApiModelProperty("新增模版对象")
    private AddSettledTemplateInfo addSettledTemplateInfo;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class DeleteTemplateInfo {
        private Long settledObjId;
        private List<Long> templateObjIdList;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class AddSettledTemplateInfo {
        private Long settledObjId;
        private List<List<InitSettledTemplateConfigRequest.CfgTemplateObj>> templateGroupList;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class UpdateTemplateInfo {
        @ApiModelProperty("更新模主信息集合")
        private List<UpdateTemplate> updateTemplateList;
        @ApiModelProperty("更新模版规则配置项集合")
        private List<SettledTemplateConifgVo.CfgTemplateObjMetadataVo> updateMetadataList;
    }


    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class UpdateTemplate {
        @ApiModelProperty("模版对象主键")
        private Long templateObjId;
        @ApiModelProperty("模版对象编码")
        private String templateObjCode;
        @ApiModelProperty("对象编码扩展code")
        private String objCodeExt;
        @ApiModelProperty("国税来源,默认sk")
        private String taxInvoiceSource;
    }

}