package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@ApiModel(description = "税务编码查询")

@JsonInclude(NON_NULL)
public class TaxCodeVO implements Serializable {

    @JsonProperty("text")
    private String text;

    @JsonProperty("value")
    private String value;

    @JsonProperty("taxRate")
    private List<String> taxRate;

    public List<String> getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(List<String> taxRate) {
        this.taxRate = taxRate;
    }

    /**
     * 税务编码名称
     * @return text
     **/
    @ApiModelProperty(value = "税务编码名称")
    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    /**
     * 税务编码号码
     * @return value
     **/
    @ApiModelProperty(value = "税务编码号码")
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TaxCodeVO taxCodeVO = (TaxCodeVO) o;
        return Objects.equals(text, taxCodeVO.text) &&
                Objects.equals(value, taxCodeVO.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(text, value);
    }

    @Override
    public String toString() {
        return "TaxCodeVO{" +
                "text='" + text + '\'' +
                ", value='" + value + '\'' +
                '}';
    }

    public TaxCodeVO() {
    }

    public TaxCodeVO(String text, String value) {
        this.text = text;
        this.value = value;
    }

    public TaxCodeVO(String text, String value, List<String> taxRate) {
        this.text = text;
        this.value = value;
        this.taxRate = taxRate;
    }
}
