package com.xforceplus.seller.config.client.parse.bean;
/**
 * Created by admin on 2018/10/16.
 */

import com.xforceplus.seller.config.client.constant.MergeRuleEnum;
import com.xforceplus.seller.config.client.constant.NagertiveRuleEnum;
import com.xforceplus.seller.config.client.constant.SecondMergeRuleEnum;
import com.xforceplus.seller.config.client.model.CombinationFieldBean;
import com.xforceplus.seller.config.client.parse.BaseRuleBean;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @Descript 组合合并规则
 * @Date
 * @return
 **/
@Data
public class BillMergerRuleDTO extends BaseRuleBean {
    @ApiModelProperty("是否自动合并")
    private Boolean autoMergeFlag;
    @ApiModelProperty("是否自动组合")
    //自动组合添加用户选择
    private String autoAssociationFlag;
    @ApiModelProperty("组合条件")
    private List<CombinationFieldBean> associationCondition = new ArrayList<>();
    @ApiModelProperty("合并条件")
    private List<CombinationFieldBean> mergerCondition = new ArrayList<>();
    @ApiModelProperty("合并规则")
    private MergeRuleEnum mergeRule ;
    @ApiModelProperty("正负合并规则")
    private NagertiveRuleEnum nagertiveRule ;
    @ApiModelProperty("是否二次合并")
    private Boolean secondMergeFlag = Boolean.FALSE;
    @ApiModelProperty("二次合并条件")
    private List<CombinationFieldBean> secondMergeCondition = new ArrayList<>();
    @ApiModelProperty("二次正负合并规则")
    private SecondMergeRuleEnum secondNagertiveRule;
    @ApiModelProperty("二次合并规则")
    private MergeRuleEnum secondMergeRule = MergeRuleEnum.no_quantity_no_Price ;

    //开放接口 额外字段
    private String invoiceLimit;
    private String extStr;
    private String commonInvoiceTypeBound;
    private String commonElectronicInvoiceTypeBound;
    private String specialInvoiceTypeBound;
    private String specialElectronicInvoiceTypeBound;

    @ApiModelProperty("是否合并赠品")
    private Boolean presentMergeFlag = Boolean.FALSE;

    @ApiModelProperty("是否限制拼接后备注长度 默认不限制")
    private Boolean remarkJoinLimitFlag = Boolean.FALSE;

    @ApiModelProperty(value = "合并后三金额（含税金额、不含税金额、税额）与合并前金额累计保持一致")
    private Boolean enableAccAmountConsistent = Boolean.FALSE;

}
