package com.xforceplus.seller.config.client.parse.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.IssueValidateConfigDTO;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

@Component
public class IssueValidateConfigParser implements ConfigParser {
    @Override
    public IssueValidateConfigDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {

        IssueValidateConfigDTO issueValidateConfigDTO = new IssueValidateConfigDTO();
        for (MsConfigItemBean msConfigItemBean : cfgConfigItemEntities) {
            issueValidateConfigDTO.setRuldId(msConfigItemBean.getConfigId());
            String fieldName = msConfigItemBean.getConfigItemName();
            List<String> itemValueList = msConfigItemBean.getConfigItemValue();
            if (CommonTools.isEmpty(fieldName)) {
                continue;
            }

            //当配置项值 设置了错误的格式，取出的集合是空则给一个默认值
            if (CollectionUtils.isEmpty(itemValueList)) {
                itemValueList = Lists.newArrayList("");
            }
            String itemValue = itemValueList.get(0);
            if ("limitAmount".equals(fieldName)) {
                issueValidateConfigDTO.setLimitAmount(new BigDecimal(itemValue));
            } else if ("limitMessageTemplate".equals(fieldName)) {
                issueValidateConfigDTO.setLimitMessageTemplate(itemValue);
            }

        }
        return issueValidateConfigDTO;
    }
}
