/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.client.parse.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.FirstIssuerRuleDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FirstIssuerParser
implements ConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(FirstIssuerParser.class);

    @Override
    public FirstIssuerRuleDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {
        FirstIssuerRuleDTO firstIssuerRuleDTO = new FirstIssuerRuleDTO();
        for (MsConfigItemBean msConfigItemBean : cfgConfigItemEntities) {
            firstIssuerRuleDTO.setRuldId(msConfigItemBean.getConfigId());
            String fieldName = msConfigItemBean.getConfigItemName();
            ArrayList itemValueList = msConfigItemBean.getConfigItemValue();
            if (CommonTools.isEmpty((String)fieldName)) continue;
            if (CollectionUtils.isEmpty(itemValueList)) {
                logger.warn("InvoiceSplitParse--parse--\u7cfb\u7edf\u914d\u7f6e\u9879\u503c\u8bbe\u7f6e\u9519\u8bef:null");
                itemValueList = Lists.newArrayList((Object[])new String[]{""});
            }
            String itemValue = itemValueList.get(0);
            if ("firstIssuer".equals(fieldName)) {
                firstIssuerRuleDTO.setFirstIssuer(itemValue);
                continue;
            }
            if ("issueType".equals(fieldName)) {
                firstIssuerRuleDTO.setIssueType(itemValue);
                continue;
            }
            if (!Objects.equals(fieldName, "autoSelectOtherOnlineIssuer")) continue;
            firstIssuerRuleDTO.setAutoSelectOtherOnlineIssuer(StringUtils.isBlank((CharSequence)itemValue) ? 1 : Integer.parseInt(itemValue));
        }
        return firstIssuerRuleDTO;
    }
}

