/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.client.parse.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.seller.config.client.constant.PriceMethodTypeEnum;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.InvoiceSplitrRuleDTO;
import io.vavr.Lazy;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InvoiceSplitParser
implements ConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceSplitParser.class);
    private static final Map<String, BiConsumer<InvoiceSplitrRuleDTO, String>> STRING_VALUE_CONVERT_MAP = (Map)Lazy.of(() -> {
        HashMap map = Maps.newHashMap();
        map.put("saleListOption", InvoiceSplitrRuleDTO::setSaleListOption);
        map.put("discountMode", InvoiceSplitrRuleDTO::setDiscountMode);
        map.put("taxDeviceType", InvoiceSplitrRuleDTO::setTaxDeviceType);
        map.put("itemSort", InvoiceSplitrRuleDTO::setItemSort);
        map.put("unitPriceAmountOps", InvoiceSplitrRuleDTO::setUnitPriceAmountOps);
        map.put("amountSplitRule", InvoiceSplitrRuleDTO::setAmountSplitRule);
        map.put("invoiceType", InvoiceSplitrRuleDTO::setInvoiceType);
        map.put("ruleStrategy", InvoiceSplitrRuleDTO::setRuleStrategy);
        map.put("taxInvoiceSource", InvoiceSplitrRuleDTO::setTaxInvoiceSource);
        return map;
    }).get();
    private static final Map<String, BiConsumer<InvoiceSplitrRuleDTO, List<String>>> STRING_VALUES_CONVERT_MAP = (Map)Lazy.of(() -> {
        HashMap map = Maps.newHashMap();
        map.put("splitFiledList", InvoiceSplitrRuleDTO::setSplitFiledList);
        map.put("invoiceRemarkFiledList", InvoiceSplitrRuleDTO::setInvoiceRemarkFiledList);
        map.put("invoiceItemRemarkFiledList", InvoiceSplitrRuleDTO::setInvoiceItemRemarkFiledList);
        map.put("goodsServicesNameFieldsList", InvoiceSplitrRuleDTO::setGoodsServicesNameFieldsList);
        map.put("itemSpecFieldsList", InvoiceSplitrRuleDTO::setItemSpecFieldsList);
        map.put("goodsServicesNameMainFieldsList", InvoiceSplitrRuleDTO::setGoodsServicesNameMainFieldsList);
        map.put("itemSpecMainFieldsList", InvoiceSplitrRuleDTO::setItemSpecMainFieldsList);
        return map;
    }).get();
    private static final Function<String, BigDecimal> DISCOUNT_RATE_LIMIT_TO_BIG_DECIMAL = itemValue -> {
        BigDecimal discountRateLimit;
        if (!NumberUtils.isNumber((String)itemValue) || StringUtils.isEmpty((CharSequence)itemValue)) {
            itemValue = "100";
        }
        if (BigDecimal.ZERO.compareTo(discountRateLimit = new BigDecimal((String)itemValue)) > 0 || new BigDecimal("100").compareTo(discountRateLimit) < 0) {
            discountRateLimit = new BigDecimal("100");
        }
        return discountRateLimit;
    };
    private static final Function<String, BigDecimal> BIZ_BILL_DISCOUNT_RATE_TO_BIG_DECIMAL = itemValue -> {
        if (!CommonTools.isEmpty((String)itemValue)) {
            if (itemValue.contains("%")) {
                itemValue = StringUtils.replace((String)itemValue, (String)"%", (String)"");
                return new BigDecimal((String)itemValue).divide(new BigDecimal("100"));
            }
        } else {
            return new BigDecimal((String)itemValue);
        }
        return new BigDecimal("1");
    };
    private static final Function<String, BigDecimal> TAX_AMOUNT_ALLOW_MAX_TO_BIG_DECIMAL = itemValue -> {
        if (!CommonTools.isEmpty((String)itemValue)) {
            try {
                return new BigDecimal((String)itemValue);
            }
            catch (Exception e) {
                logger.error("\u7a0e\u989d\u8bef\u5dee\u5fc5\u987b\u4e3a\u6570\u503c\u4e14\u4e0d\u5927\u4e8e1.27", (Throwable)e);
            }
        }
        return null;
    };
    private static final Map<String, Tuple2<Function<String, BigDecimal>, BiConsumer<InvoiceSplitrRuleDTO, BigDecimal>>> BIGDECIMAL_VALUE_CONVERT_DEFAULT_FALSE_MAP = (Map)Lazy.of(() -> {
        HashMap map = Maps.newHashMap();
        map.put("discountRateLimit", Tuple.of(DISCOUNT_RATE_LIMIT_TO_BIG_DECIMAL, InvoiceSplitrRuleDTO::setDiscountRateLimit));
        map.put("bizBillDiscountRate", Tuple.of(BIZ_BILL_DISCOUNT_RATE_TO_BIG_DECIMAL, InvoiceSplitrRuleDTO::setBizBillDiscountRate));
        map.put("taxAmountAllowMax", Tuple.of(TAX_AMOUNT_ALLOW_MAX_TO_BIG_DECIMAL, InvoiceSplitrRuleDTO::setTaxAmountAllowMax));
        return map;
    }).get();

    @Override
    public InvoiceSplitrRuleDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {
        InvoiceSplitrRuleDTO invoiceSplitrRuleDTO = new InvoiceSplitrRuleDTO();
        for (MsConfigItemBean tmp : cfgConfigItemEntities) {
            invoiceSplitrRuleDTO.setRuldId(tmp.getConfigId());
            String fieldName = tmp.getConfigItemName();
            ArrayList itemValueList = tmp.getConfigItemValue();
            if (CollectionUtils.isEmpty(itemValueList)) {
                itemValueList = Lists.newArrayList((Object[])new String[]{""});
            }
            String itemValue = itemValueList.get(0);
            if ("invoiceLimit".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue)) {
                    logger.info("\u5f00\u7968\u9650\u989d\u4e3a\u7a7a\u3002\u3002\u3002\u3002\u3002\u3002");
                    invoiceSplitrRuleDTO.setInvoiceLimit(null);
                    continue;
                }
                if (new BigDecimal(itemValue).compareTo(BigDecimal.ZERO) <= 0) {
                    throw new RuntimeException("\u5f00\u7968\u9650\u989d\u5fc5\u987b\u5927\u4e8e0");
                }
                invoiceSplitrRuleDTO.setInvoiceLimit(new BigDecimal(itemValue));
                continue;
            }
            if ("priceMethod".equals(fieldName)) {
                if (!NumberUtils.isNumber((String)itemValue)) {
                    itemValue = "0";
                    logger.info("\u4ef7\u683c\u65b9\u5f0f\uff1a0-\u4e0d\u542b\u7a0e 1-\u542b\u7a0e \u5f53\u524d\u4f20\u5165\u503c\u4e0d\u5728\u8303\u56f4\u5185.\u4f7f\u7528\u9ed8\u8ba4\u4ef7\u683c\u65b9\u5f0f\uff1a0-\u4e0d\u542b\u7a0e");
                }
                PriceMethodTypeEnum priceMethodTypeEnum = PriceMethodTypeEnum.fromValue(Integer.parseInt(itemValue));
                invoiceSplitrRuleDTO.setPriceMethod(priceMethodTypeEnum);
                continue;
            }
            if ("mergeBySplitField".equals(fieldName)) {
                int mergeBySplitField;
                if (!NumberUtils.isNumber((String)itemValue) || StringUtils.isEmpty((CharSequence)itemValue)) {
                    itemValue = "0";
                }
                if ((mergeBySplitField = Integer.parseInt(itemValue)) < 0 || mergeBySplitField > 1) {
                    mergeBySplitField = 0;
                }
                invoiceSplitrRuleDTO.setMergeBySplitField(mergeBySplitField != 0);
                continue;
            }
            if ("salesListMaxRow".equals(fieldName)) {
                if (null == itemValue || !Pattern.compile("^[\\d]*$").matcher(itemValue).matches()) {
                    logger.info("\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570\u53ea\u80fd\u4e3a\u6574\u6570\uff0c\u4f20\u5165\u503c\uff1a{}", (Object)itemValue);
                    throw new RuntimeException("\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570\u53ea\u80fd\u4e3a\u6574\u6570");
                }
                invoiceSplitrRuleDTO.setSalesListMaxRow(itemValue.equals("") ? 0 : Integer.parseInt(itemValue));
                continue;
            }
            if ("integerOps".equals(fieldName)) {
                invoiceSplitrRuleDTO.setIntegerOps(Boolean.parseBoolean(itemValue.equals("") ? "false" : itemValue));
                continue;
            }
            if ("invoiceItemMaxRow".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue)) {
                    invoiceSplitrRuleDTO.setInvoiceItemMaxRow(null);
                    continue;
                }
                if (new BigDecimal(itemValue).compareTo(BigDecimal.ZERO) < 0) {
                    throw new RuntimeException("\u7968\u9762\u884c\u6570\u4e0d\u80fd\u5c0f\u4e8e0");
                }
                invoiceSplitrRuleDTO.setInvoiceItemMaxRow(CommonTools.isEmpty((String)itemValue) ? 0 : Integer.parseInt(itemValue));
                continue;
            }
            if ("customRemarkSize".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue)) continue;
                if (itemValue.matches("^-?\\d+$")) {
                    invoiceSplitrRuleDTO.setCustomRemarkSize(Integer.valueOf(itemValue));
                    continue;
                }
                throw new RuntimeException("\u81ea\u5b9a\u4e49\u5907\u6ce8\u957f\u5ea6\u5fc5\u987b\u4e3a\u6574\u6570");
            }
            if ("priceScale".equals(fieldName)) {
                try {
                    invoiceSplitrRuleDTO.setPriceScale(Integer.parseInt(itemValue));
                }
                catch (Exception e) {
                    logger.error("\u89e3\u6790\u62c6\u7968\u89c4\u5219\u5355\u4ef7\u4f4d\u6570\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                    invoiceSplitrRuleDTO.setPriceScale(15);
                }
                continue;
            }
            if ("invoiceRemarkDistinctFlag".equals(fieldName)) {
                invoiceSplitrRuleDTO.setRemarkDuplicateFlag(Boolean.parseBoolean("".equals(itemValue) ? "true" : String.valueOf("1".equals(itemValue))));
                continue;
            }
            if ("hideRemarkFieldName".equals(fieldName)) {
                if ("1".equals(itemValue)) {
                    invoiceSplitrRuleDTO.setHideRemarkFieldName("true");
                    continue;
                }
                invoiceSplitrRuleDTO.setHideRemarkFieldName("false");
                continue;
            }
            if ("printItemSpecFlag".equals(fieldName)) {
                if ("1".equals(itemValue)) {
                    invoiceSplitrRuleDTO.setPrintItemSpecFlag("false");
                    continue;
                }
                invoiceSplitrRuleDTO.setPrintItemSpecFlag("true");
                continue;
            }
            if ("outerToInnerDiscount".equals(fieldName)) {
                if ("1".equals(itemValue)) {
                    invoiceSplitrRuleDTO.setOuterToInnerDiscount("true");
                    continue;
                }
                invoiceSplitrRuleDTO.setOuterToInnerDiscount("false");
                continue;
            }
            if ("remarkKeyValueShowType".equals(fieldName)) {
                if (CommonTools.isEmpty((String)itemValue)) continue;
                invoiceSplitrRuleDTO.setRemarkKeyValueShowType(Integer.parseInt(itemValue));
                continue;
            }
            if ("quantityLimitTuple".equals(fieldName)) {
                if (!CollectionUtils.isNotEmpty(tmp.getConfigItemValue())) continue;
                invoiceSplitrRuleDTO.setQuantityLimitDtoList(tmp.getConfigItemValue().stream().filter(StringUtils::isNotBlank).map(r -> (InvoiceSplitrRuleDTO.QuantityLimitDto)JSON.parseObject((String)r, InvoiceSplitrRuleDTO.QuantityLimitDto.class)).collect(Collectors.toList()));
                continue;
            }
            if (!this.stringValueConvert(invoiceSplitrRuleDTO, fieldName, itemValue) && !this.stringValuesConvert(invoiceSplitrRuleDTO, fieldName, itemValueList) && !this.bigDecimalValueConvert(invoiceSplitrRuleDTO, fieldName, itemValue)) continue;
        }
        if (StringUtils.isEmpty((CharSequence)invoiceSplitrRuleDTO.getTaxInvoiceSource())) {
            invoiceSplitrRuleDTO.setTaxInvoiceSource("sk");
        }
        return invoiceSplitrRuleDTO;
    }

    private boolean stringValueConvert(InvoiceSplitrRuleDTO invoiceSplitrRuleDTO, String fieldName, String itemValue) {
        boolean hitField = STRING_VALUE_CONVERT_MAP.containsKey(fieldName);
        if (hitField) {
            Optional.ofNullable(STRING_VALUE_CONVERT_MAP.get(fieldName)).ifPresent(consumer -> consumer.accept(invoiceSplitrRuleDTO, itemValue));
        }
        return hitField;
    }

    private boolean stringValuesConvert(InvoiceSplitrRuleDTO invoiceSplitrRuleDTO, String fieldName, List<String> itemValues) {
        boolean hitField = STRING_VALUES_CONVERT_MAP.containsKey(fieldName);
        if (hitField && !StringUtils.isEmpty((CharSequence)itemValues.get(0))) {
            Optional.ofNullable(STRING_VALUES_CONVERT_MAP.get(fieldName)).ifPresent(consumer -> consumer.accept(invoiceSplitrRuleDTO, itemValues));
        }
        return hitField;
    }

    private boolean bigDecimalValueConvert(InvoiceSplitrRuleDTO invoiceSplitrRuleDTO, String fieldName, String itemValue) {
        boolean hitField = BIGDECIMAL_VALUE_CONVERT_DEFAULT_FALSE_MAP.containsKey(fieldName);
        if (hitField) {
            Optional.ofNullable(BIGDECIMAL_VALUE_CONVERT_DEFAULT_FALSE_MAP.get(fieldName)).ifPresent(consumer -> ((BiConsumer)consumer._2).accept(invoiceSplitrRuleDTO, ((Function)consumer._1).apply(itemValue)));
        }
        return hitField;
    }
}

