/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.client.parse.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.RedConfirmMatchRuleDTO;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RedConfirmParser
implements ConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(RedConfirmParser.class);

    @Override
    public RedConfirmMatchRuleDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {
        if (CollectionUtils.isEmpty(cfgConfigItemEntities)) {
            return null;
        }
        RedConfirmMatchRuleDTO redConfirmMatchRuleDTO = new RedConfirmMatchRuleDTO();
        for (MsConfigItemBean msConfigItemBean : cfgConfigItemEntities) {
            String value;
            redConfirmMatchRuleDTO.setRuldId(msConfigItemBean.getConfigId());
            String fieldName = msConfigItemBean.getConfigItemName();
            if (StringUtils.isEmpty((CharSequence)fieldName)) continue;
            ArrayList itemValueList = msConfigItemBean.getConfigItemValue();
            if (CollectionUtils.isEmpty(itemValueList)) {
                logger.info("RedConfirmParser--itemValueList--parse--Merge\u914d\u7f6e\u9879\u503c\u8bbe\u7f6e\u9519\u8bef:null");
                itemValueList = Lists.newArrayList((Object[])new String[]{""});
            }
            if (!CommonTools.isEmpty((String)(value = itemValueList.get(0)))) {
                if ("matchRule".equals(fieldName)) {
                    redConfirmMatchRuleDTO.setMatchRule(value);
                } else if ("matchCalRule".equals(fieldName)) {
                    redConfirmMatchRuleDTO.setMatchCalRule((String)itemValueList.get(0));
                } else if ("matchDiff".equals(fieldName)) {
                    redConfirmMatchRuleDTO.setMatchDiff((String)itemValueList.get(0));
                } else if ("matchItemDiff".equals(fieldName)) {
                    redConfirmMatchRuleDTO.setMatchItemDiff((String)itemValueList.get(0));
                } else if ("unitPriceDiff".equals(fieldName)) {
                    redConfirmMatchRuleDTO.setUnitPriceDiff((String)itemValueList.get(0));
                }
                if ("taxAmountDiff".equals(fieldName)) {
                    redConfirmMatchRuleDTO.setTaxAmountDiff(value);
                }
                if ("mainMatchStrategy".equals(fieldName)) {
                    try {
                        if (StringUtils.isBlank((CharSequence)value)) {
                            redConfirmMatchRuleDTO.setMainMatchStrategy(Lists.newArrayList());
                        } else {
                            redConfirmMatchRuleDTO.setMainMatchStrategy(JsonUtils.writeJsonToListObject((String)value, RedConfirmMatchRuleDTO.MainMatchCondition.class));
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u89e3\u6790\u5339\u914d\u7b56\u7565\u5b57\u6bb5\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
                        throw new RuntimeException("\u89e3\u6790\u5339\u914d\u7b56\u7565\u5b57\u6bb5\u5f02\u5e38");
                    }
                }
            }
            if (!"matchCondition".equals(fieldName) || !CollectionUtils.isNotEmpty(msConfigItemBean.getConfigItemValue())) continue;
            redConfirmMatchRuleDTO.setMatchCondition(itemValueList);
        }
        return redConfirmMatchRuleDTO;
    }
}

