package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "billSplitConfig", description = "the billSplitConfig API")
public interface BillSplitConfigApi {

    @ApiOperation(value = "查询单据拆合规则", notes = "", response = MsConfigResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询响应", response = MsConfigResponse.class) })
    @RequestMapping(value = "/billSplitConfig/queryEffectiveBillSplitRule",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsConfigResponse queryEffectiveBillSplitRule(@ApiParam(value = "查询单据拆合规则"  ) @RequestBody MsConfigQueryRequest msConfigQueryRequest);

}
