package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.QueryCustomFiltersRequest;
import com.xforceplus.seller.config.client.model.QueryCustomFiltersResponse;
import com.xforceplus.seller.config.client.model.SaveCustomFiltersRequest;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/4/3 21:30
 */
@Api(value = "custom-filter", description = "the CustomFilter API")
public interface CustomFiltersApi {

    @ApiOperation(value = "查询自定义条件", notes = "", response = QueryCustomFiltersResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "CustomFilter", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = QueryCustomFiltersResponse.class) })
    @RequestMapping(value = "/meta-data/get-filter-items",
            produces = { "application/json" },
            method = RequestMethod.POST)
    QueryCustomFiltersResponse queryCustomFilters(@ApiParam(value = "查询自定义条件请求" ,required=true ) @RequestBody QueryCustomFiltersRequest queryCustomFiltersRequest);

    @ApiOperation(value = "保存自定义条件", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "CustomFilter", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "保存响应", response = Response.class) })
    @RequestMapping(value = "/meta-data/save-filter-items",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response saveCustomFilters(@ApiParam(value = "保存自定义条件请求" ,required=true ) @RequestBody SaveCustomFiltersRequest saveCustomFiltersRequest);
}
