package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.*;

import com.xforceplus.seller.config.client.parse.bean.InvoiceInfoRuleDTO;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import java.util.List;
import java.util.Map;


@Api(value = "invoiceSplitConfig", description = "the invoiceSplitConfig API")
public interface InvoiceSplitConfigApi {

    @ApiOperation(value = "查询匹配最优配置规则", notes = "", response = MsResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/invoiceSplitConfig/getOptimalMatchConfig",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse getOptimalMatchConfig(@ApiParam(value = "查询匹配最优配置规则"  ) @RequestBody MsConfigQueryRequest msConfigQueryRequest);


    @ApiOperation(value = "查询匹配最优配置规则", notes = "", response = MsResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/invoiceSplitConfig/getBestMatchConfig",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsResponse getBestMatchConfig(@ApiParam(value = "查询匹配最优配置规则"  ) @RequestBody MsConfigQueryRequest msConfigQueryRequest);

    @ApiOperation(value = "(零售)查询匹配最优配置规则", notes = "", response = MsResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/order/getOptimalMatchConfig",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsResponse getOrderOptimalMatchConfig(@ApiParam(value = "查询匹配最优配置规则"  ) @RequestBody MsConfigQueryRequest msConfigQueryRequest);

    @ApiOperation(value = "查询匹配的所有规则", notes = "", response = MsResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/invoiceSplitConfig/queryAllSysConfig",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsResponse queryAllSysConfig(@ApiParam(value = "查询匹配的所有规则"  ) @RequestBody MsConfigQueryRequest msConfigQueryRequest);

    @ApiOperation(value = "批量查询匹配的各自最优规则", notes = "", response = MsResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/invoiceSplitConfig/batchQueryOptimalMatchConfig",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsResponse<Map<String, List<String>>> batchQueryOptimalMatchConfig(@ApiParam(value = "查询匹配全部配置规则") @RequestBody MsConfigBatchQueryRequest request);

    @ApiOperation(value = "查询匹配的各自最优规则集合", notes = "", response = MsResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/invoiceSplitConfig/getOptimalMatchConfigList",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsResponse<String> getOptimalMatchConfigList(@ApiParam(value = "查询匹配最优配置规则") @RequestBody MsConfigQueryRequest msConfigQueryRequest);


    @ApiOperation(value = "票面信息获取", notes = "", response = MsResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/invoiceSplitConfig/getSellerIssueInfoConfig",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsResponse<List<InvoiceInfoRuleDTO>> getSellerIssueInfoConfig(@ApiParam(value = "票面信息获取" ) @RequestBody MsConfigQueryRequest msConfigQueryRequest);


    @ApiOperation(value = "获取租户下指定类型的购销方税号(比如组合合并规则)", notes = "", response = MsResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/getConfigByTenantId",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsResponse<List<MsConfigBean>> getConfigByTenantId(@ApiParam(value = "获取指定类型全量的购销方信息" ) @RequestBody MsConfigQueryRequest msConfigQueryRequest);


    @ApiOperation(value = "查询添加开票人权限（页面开具、红冲场景）", notes = "", response = MsResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "ConfigDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/getAllowAddIssuerConfig",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsResponse<Boolean> getAllowAddIssuerConfig(@ApiParam(value = "查询添加开票人权限（页面开具、红冲场景）" ) @RequestBody MsConfigQueryRequest msConfigQueryRequest);

    @ApiOperation(value = "查询匹配最优配置规则（返回实际配置明细项，不需要调用方二次解析）", notes = "", response = MsResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags = {"ConfigDefinitions",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class)})
    @RequestMapping(value = "/invoiceSplitConfig/getOptimalMatchConfigActualItem",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<MsConfigWithActualItemDto> getOptimalMatchConfigActualItem(@ApiParam(value = "查询匹配最优配置规则") @RequestBody MsConfigQueryRequest msConfigQueryRequest);


    @ApiOperation(value = "查询匹配最优配置规则（返回实际配置明细项，不需要调用方二次解析）", notes = "", response = MsResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags = {"ConfigDefinitions",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class)})
    @RequestMapping(value = "/invoiceSplitConfig/getOptimalMatchConfigActualItemSmart",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<List<MsConfigWithActualItemDto>> getOptimalMatchConfigActualItemSmart(@ApiParam(value = "查询匹配最优配置规则") @RequestBody MsConfigQueryRequest msConfigQueryRequest);
}
