package com.xforceplus.seller.config.client.api;

import com.xforceplus.seller.config.client.model.*;

import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "meta", description = "the meta API")
public interface MetaApi {

    @ApiOperation(value = "保存元数据对象", notes = "", response = MsMetadataItemResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "MetaDataDefinitions", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "查询响应", response = MsMetadataItemResponse.class) })
    @RequestMapping(value = "/meta/batchQueryWithObjCodeFiledName",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsMetadataItemResponse batchQueryWithObjCodeFiledName(@ApiParam(value = "元数据对象查询" ,required=true ) @RequestBody MsMataDataBatchQueryRequest mataDataBatchQueryRequest);


    @ApiOperation(value = "元数据对象删除", notes = "", response = MsResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "MetaDataDefinitions", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/meta/metaDataDelete",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsResponse metaDataDelete(@ApiParam(value = "元数据对象查询" ,required=true ) @RequestBody MsMataDataDeleteRequestWithUserInfo mataDataDeleteRequestWithUserInfo);

    @ApiOperation(value = "查看业务单类型是否配置规则", notes = "", response = MsResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "MetaDataDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/bizorder/rule/exist",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsResponse bizorderRuleExist(@ApiParam(value = "元数据对象查询" ,required=true ) @RequestBody MsMataDataDeleteRequest mataDataDeleteRequestWithUserInfo);


    @ApiOperation(value = "元数据对象删除", notes = "", response = MsMetaDataSummaryResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "MetaDataDefinitions", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "查询响应", response = MsMetaDataSummaryResponse.class) })
    @RequestMapping(value = "/meta/metaDataSummary",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsMetaDataSummaryResponse metaDataSummary(@ApiParam(value = "元数据对象查询" ,required=true ) @RequestBody MsMataDataQueryRequest mataDataQueryRequest);


    @ApiOperation(value = "元数据对象查询", notes = "", response = MsMetadataItemResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "MetaDataDefinitions", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "查询响应", response = MsMetadataItemResponse.class) })
    @RequestMapping(value = "/meta/queryEffctiveMetaData",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsMetadataItemResponse queryEffctiveMetaData(@ApiParam(value = "元数据对象查询" ,required=true ) @RequestBody MsMataDataQueryRequest mataDataQueryRequest);


    @ApiOperation(value = "保存元数据对象", notes = "", response = MsGroupTypeMetaDataResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "MetaDataDefinitions", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "查询响应", response = MsGroupTypeMetaDataResponse.class) })
    @RequestMapping(value = "/meta/queryGroupMetaDataWithObjType",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsGroupTypeMetaDataResponse queryGroupMetaDataWithObjType(@ApiParam(value = "元数据对象查询" ,required=true ) @RequestBody MsMataDataQueryRequest groupId);


    @ApiOperation(value = "保存元数据对象", notes = "", response = MsGroupTypeResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "MetaDataDefinitions", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "查询响应", response = MsGroupTypeResponse.class) })
    @RequestMapping(value = "/meta/queryGroupObjType",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsGroupTypeResponse queryGroupObjType(@ApiParam(value = "元数据对象查询" ,required=true ) @RequestBody MsMataDataQueryRequest groupId);


    @ApiOperation(value = "查询已授权业务单类型列表信息", notes = "", response = MsGroupTypeResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "MetaDataDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = MsGroupTypeResponse.class) })
    @RequestMapping(value = "/meta/queryAuthorizationBillTypeList",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsGroupTypeResponse queryAuthorizationBillTypeList(@ApiParam(value = "查询已授权业务单类型列表信息" ,required=true ) @RequestBody MsMataDataQueryRequest msMataDataQueryRequest);


    @ApiOperation(value = "获取列高亮显示约束条件List", notes = "", response = MsQueryHighlightFieldListResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "MetaDataDefinitions", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "查询响应", response = MsQueryHighlightFieldListResponse.class) })
    @RequestMapping(value = "/meta/queryHighlightFieldList",
        produces = { "application/json" },
        method = RequestMethod.GET)
     MsQueryHighlightFieldListResponse queryHighlightFieldList( @NotNull @ApiParam(value = "模板编码", required = true) @RequestParam(value = "objCode", required = true) String objCode, @NotNull @ApiParam(value = "单据对象类型", required = true) @RequestParam(value = "objType", required = true) String objType, @ApiParam(value = "集团id") @RequestParam(value = "groupId", required = false) Long groupId);


    @ApiOperation(value = "查询元数据对象", notes = "", response = MsMetaDataResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "MetaDataDefinitions", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "查询响应", response = MsMetaDataResponse.class) })
    @RequestMapping(value = "/meta/queryMetaData",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsMetaDataResponse queryMetaData(@ApiParam(value = "业务对象保存" ,required=true ) @RequestBody MsMataDataQueryRequest mataDataQueryRequest);


    @ApiOperation(value = "查询数据明细", notes = "", response = MsMetadataItemResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "MetaDataDefinitions", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "查询响应", response = MsMetadataItemResponse.class) })
    @RequestMapping(value = "/meta/queryMetaDataItem",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsMetadataItemResponse queryMetaDataItem(@ApiParam(value = "元数据对象查询" ,required=true ) @RequestBody MsMetadataItemQueryRequest metadataItemQueryRequest);


    @ApiOperation(value = "模板元数据对象查询", notes = "", response = MsMetadataItemResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "MetaDataDefinitions", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "查询响应", response = MsMetadataItemResponse.class) })
    @RequestMapping(value = "/meta/queryTemplateMetaData",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsMetadataItemResponse queryTemplateMetaData(@ApiParam(value = "模板元数据对象查询" ,required=true ) @RequestBody MsMataDataQueryRequest mataDataQueryRequest);


    @ApiOperation(value = "保存元数据对象", notes = "", response = MsResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "MetaDataDefinitions", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "保存响应", response = MsResponse.class) })
    @RequestMapping(value = "/meta/saveMetaData",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsResponse saveMetaData(@ApiParam(value = "业务对象保存" ,required=true ) @RequestBody MsMataDataAddRequestWithUserInfo mataDataAddRequestWithUserInfo);


    @ApiOperation(value = "保存元数据对象", notes = "", response = MsResponse.class, authorizations = {
        @Authorization(value = "x-access-token")
    }, tags={ "MetaDataDefinitions", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "查询响应", response = MsResponse.class) })
    @RequestMapping(value = "/meta/saveMetaDataItem",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsResponse saveMetaDataItem(@ApiParam(value = "元数据对象查询" ,required=true ) @RequestBody MsMetadataItemAddRequestWithUserInfo metadataItemAddRequestWithUserInfo);


    @ApiOperation(value = "元数据对象", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "MetaDataDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = Response.class) })
    @RequestMapping(value = "/meta/queryMetaObjMetadata",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response queryMetaObjMetadata(@ApiParam(value = "元数据对象查询" ,required=true ) @RequestBody MsMataItemDataQueryRequest msMataItemDataQueryRequest);

    @ApiOperation(value = "查询元数据主对象", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "MetaDataDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = Response.class) })
    @RequestMapping(value = "/meta/queryMetaObj",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response queryMetaObj(@ApiParam(value = "查询元数据主对象" ,required=true ) @RequestBody MsBusinessObjRequest msBusinessObjRequest);

    @ApiOperation(value = "保存或更新元数据对象", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "MetaDataDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = Response.class) })
    @RequestMapping(value = "/meta/addOrUpdateMetaObjData",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response addOrUpdateMetaObjData(@ApiParam(value = "保存或更新元数据对象" ,required=true ) @RequestBody MsBusinessObjBean msBusinessObjBean);

    @ApiOperation(value = "保存元数据对象", notes = "", response = MsGroupTypeResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "MetaDataDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = MsGroupTypeResponse.class) })
    @RequestMapping(value = "/meta/queryGroupObjType4local",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsGroupTypeResponse queryGroupObjType4local(@ApiParam(value = "元数据对象查询" ,required=true ) @RequestBody MsMataDataQueryRequest groupId);


    @ApiOperation(value = "用户中心调用：查询元数据", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "MetaDataDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = Response.class) })
    @RequestMapping(value = "/meta/getMetaDataList",
            produces = { "application/json" },
            method = RequestMethod.GET)
    Response<List<MsGroupTypeDTO>> getMetaDataList(@RequestParam(value = "tenantId", required = true) Long tenantId, @RequestParam(value = "needDetailExt", required = true) boolean needDetailExt, @RequestParam(value = "needNotEnumExt", required = true) boolean needNotEnumExt);

    @ApiOperation(value = "新业务单类型删除校验", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "MetaDataDefinitions", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询响应", response = Response.class) })
    @RequestMapping(value = "/meta/bizOrderDeleteCheckForNew",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response<Object> bizOrderDeleteCheckForNew(@RequestBody List<String> salesbillTypeList);

}
