package com.xforceplus.seller.config.client.constant;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.EnumUtils;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * 项目名称:  phoenix-config
 * 模块名称:
 * 说明: 规则类型枚举
 * JDK 版本: JDK1.8
 * @author 作者： Created by zzw
 * 创建日期：2018/9/19.
 */
@RequiredArgsConstructor
@Getter
public enum ConfigTypeEnum {
    /**
     * 拆票规则
     */
    SPLIT_CONFIG_TYPE(1,"拆票规则","invoiceSplitConfig"),
    /**
     * 拆合规则
     */
    MERGE_CONFIG_TYPE(2,"拆合规则","billMergeSplitConfig"),
    /**
     * 票面信息规则
     */
    INVOICE_CONFIG_TYPE(3,"票面信息规则","invoiceInfoConfig"),
    /**
     * 票面人员规则
     */
    INVOICE_USER_CONFIG_TYPE(4,"票面人员规则","invoiceMemberInfoConfig"),
    /**
     * 业务流程规则
     */
    PROCESS_CONFIG_TYPE(5,"业务流程规则","pageProcssConfig"),
    /**
     * 系统规则
     */
    SYS_CONFIG_TYPE(6,"系统规则","sysConfig"),

    /**
     * 组合合并规则
     */
    BILL_MERGE_TYPE(7,"组合合并规则","mergeRule"),

    /**
     * 发票匹配业务单规则
     */
    BILL_INVOICE_MATCH_TYPE(8, "发票匹配业务单", "invoiceMatchConfig"),

    /**
     * 自动开票红冲规则
     */
    VIRTUAL_INVOICE_AUTO_RULE_TYPE(9, "自动开票红冲规则", "virtualInvoiceAutoRule"),

    /**
     * 发票邮件推送规则
     */
    INVOICE_MAIL_RULE_CONFIG_TYPE(10, "发票邮件推送规则", "invoiceMailRuleConfig"),

    /**
     * 发票邮件推送规则
     */
    INVOICE_OPERRATIOON_CONFIG_TYPE(11, "发票红冲作废原因规则", "invoiceOperationConfig"),

    /**
     * 未知拆票规则
     */
    UNKNOWN(0, "未知规则", "unknown"),

    /**
     * 票面信息规则
     */
    MULTI_INVOICE_TITLE_CONFIG_TYPE(12,"抬头信息规则","invoiceTitleConfig"),

    /**
     * 订单搜索条件配置
     */
    ORDER_SEARCH_CONFIG_TYPE(13,"订单搜索条件配置","orderSearchConfig"),

    /**
     * 系统规则
     */
    H5_SYS_CONFIG_TYPE(14,"H5规则配置","h5SystermConfig"),

    /**
     * 折扣率规则
     */
    DISCOUNT_RATE_CONFIG_TYPE(15, "折扣率规则配置", "discountRateConfig"),
    RED_CONFIRM_MATCH_CONFIG_TYPE(16, "红字确认单配置", "redConfirmMatchConfig"),
    FIRST_INVOICER(17, "优先开票人配置", "firstInvoicer"),
    PURCHASE_RESALE_TYPE(18, "进转销规则", "purchaseResaleType"),
    SMART_MATCH_CONFIG_TYPE(19, "智能推荐规则", "smartMatchConfig"),
    DISCONNECT_NOTICE_CONFIG_TYPE(20, "掉线通知规则", "disconnectNoticeConfig"),
    /**
     * 这个开票检验规则的配置项是前端写死的,不读取模版表的定义
     */
    ISSUE_VALIDATE_CONFIG_TYPE(21, "开票校验规则", "issueValidateConfig"),
    INVOICE_FIELD_CONVERT_CONFIG_TYPE(22, "票面转换规则", "invoiceFieldConvertConfig"),
    INVOICE_RISK_CONTROL_CONFIG_TYPE(23, "开票风控规则", "invoiceFieldConvertConfig");

    private final Integer configType;
    private final String configTypeDesc;
    private final String objCode;

    public static ConfigTypeEnum of(Integer configType) {
        if (configType == null) {
            return ConfigTypeEnum.UNKNOWN;
        }

        return Stream.of(ConfigTypeEnum.values()).filter(c -> Objects.equals(c.configType, configType)).findFirst().orElse(ConfigTypeEnum.UNKNOWN);
    }

    public static ConfigTypeEnum getConfigTypeByValue(Integer configType) {
        ConfigTypeEnum[] configTypeEnums = ConfigTypeEnum.values();
        for (ConfigTypeEnum tmp : configTypeEnums) {
            if (tmp.getConfigType().equals(configType)) {
                return tmp;
            }
        }
        return null;
    }

    public static Optional<ConfigTypeEnum> getConfigTypeByObjCode(String objCode) {
        return EnumUtils.getEnumList(ConfigTypeEnum.class)
                .stream()
                .filter(r -> r.getObjCode().equals(objCode))
                .findFirst();
    }

}
