package com.xforceplus.seller.config.client.constant;

import java.util.stream.Stream;

public enum PriceMethodTypeEnum {
       /**
     * 含税价格
     */
    WITH_PRICE(1,"含税价格"),
    /**
     * 不含税价格
     */
    WITHOUT_PRICE(0,"不含税价格");

    int value;
    String desc;

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    PriceMethodTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static PriceMethodTypeEnum fromValue(int value) {
        return (PriceMethodTypeEnum) Stream.of(values()).filter((t) -> {
            return t.getValue() == value;
        }).findFirst().orElse(null);
    }
}
