package com.xforceplus.seller.config.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

@ApiModel("查询全电开票人信息列表")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class AllElectricIssuerInfoData implements Serializable {
  @ApiModelProperty("销方税号")
  private String taxNo;
  @ApiModelProperty("登录方式: 枚举: client,server 枚举备注: client：客户端登录 server：服务端登录")
  private String loginType;
  @ApiModelProperty("开票人列表")
  private List<AllElectricIssuerInfo> issuers;

}
