package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class AllElectricIssuerRequest {

    @ApiModelProperty("销方税号列表")
    @JsonProperty("taxNoList")
    private List<String> taxNoList;

    @ApiModelProperty("税号下的开票人")
    @JsonProperty("issuer")
    private String issuer;

    @ApiModelProperty("登录状态 0-离线 1-在线 2-全部")
    @JsonProperty("onLineState")
    private Integer onLineState;

    @ApiModelProperty("登录状态 0-无需认证 1-需要认证 2-全部")
    @JsonProperty("needRealMeAuthState")
    private Integer needRealMeAuthState;

    @ApiModelProperty("税号权限过滤 true-过滤 默认值 false-不过滤")
    @JsonProperty("needPermission")
    private Boolean needPermission = true;

    @ApiModelProperty("当前页,从1开始")
    @JsonProperty("pageIndex")
    private Integer pageIndex;

    @ApiModelProperty("每页数量，默认不传为20条")
    @JsonProperty("pageSize")
    private Integer pageSize;

    @ApiModelProperty("带人员关系权限查询")
    @JsonProperty("queryWithAuth")
    private Boolean queryWithAuth = false;

    @ApiModelProperty("开票人状态（disabled-停用 enabled-启用）")
    @JsonProperty("status")
    private String status;

}
