package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class ConfigDeleteElectricIssuerInfoRequest implements Serializable {
    @ApiModelProperty("删除开票人集合")
    private List<ConfigDeleteElectricIssuerInfo> list;

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class ConfigDeleteElectricIssuerInfo implements Serializable {
        @ApiModelProperty("销方公司名称")
        @JsonProperty("companyName")
        private String companyName;

        @ApiModelProperty("销方税号")
        @JsonProperty("taxNo")
        private String taxNo;

        @ApiModelProperty("税号下的开票人")
        @JsonProperty("issuer")
        private String issuer;

        @ApiModelProperty("开票方式 ns-乐企 dppt-电票平台")
        @JsonProperty("issueType")
        private String issueType;

        @ApiModelProperty("唯一标识")
        @JsonProperty("uniqueKey")
        private String uniqueKey;
    }

}
