package com.xforceplus.seller.config.client.model;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * openapi新增规则请求
 */
@Data
public class ConfigOpenAddRequest implements Serializable {
    /**
     * 规则名称
     */
    private String configName;
    /**
     * 规则类型
     */
    private Integer configType;
    /**
     * 发票类型
     */
    private String invoiceType;
    /**
     * AR/AP类型
     */
    private String businessBillType;
    /**
     * 业务单类型
     */
    private String salesbillType;
    /**
     * 销方名称
     */
    private String sellerName;
    /**
     * 销方税号
     */
    private String sellerTaxNo;
    /**
     * 购方名称
     */
    private String purchaserName;
    /**
     * 购方税号
     */
    private String purchaserTaxNo;
    /**
     * 扩展属性
     */
    private List<MsConfigBizBillAttribute> attributeList;
    /**
     * 发票推送规则配置项
     */
    private InvoiceSendMailRule invoiceSendMailRule;
}
