package com.xforceplus.seller.config.client.model;

import java.io.Serializable;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsBusinessObjMetadataBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsBusinessObjBean implements Serializable {
  @JsonProperty("businessObjId")
  private Long businessObjId = null;

  @JsonProperty("objCode")
  private String objCode = null;

  @JsonProperty("objName")
  private String objName = null;

  @JsonProperty("objDesc")
  private String objDesc = null;

  @JsonProperty("objType")
  private String objType = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("channel")
  private String channel = null;

  @JsonProperty("items")
  private List<MsBusinessObjMetadataBean> items = new ArrayList<MsBusinessObjMetadataBean>();

  @ApiModelProperty("零售业务单标识")
  @Getter
  @Setter
  private Integer objFlag = null;

  @JsonIgnore
  public MsBusinessObjBean businessObjId(Long businessObjId) {
    this.businessObjId = businessObjId;
    return this;
  }

   /**
   * null
   * @return businessObjId
  **/
  @ApiModelProperty(value = "null")
  public Long getBusinessObjId() {
    return businessObjId;
  }

  public void setBusinessObjId(Long businessObjId) {
    this.businessObjId = businessObjId;
  }

  @JsonIgnore
  public MsBusinessObjBean objCode(String objCode) {
    this.objCode = objCode;
    return this;
  }

   /**
   * null
   * @return objCode
  **/
  @ApiModelProperty(value = "null")
  public String getObjCode() {
    return objCode;
  }

  public void setObjCode(String objCode) {
    this.objCode = objCode;
  }

  @JsonIgnore
  public MsBusinessObjBean objName(String objName) {
    this.objName = objName;
    return this;
  }

  public String getChannel() {
    return channel;
  }

  public void setChannel(String channel) {
    this.channel = channel;
  }

  /**
   * null
   * @return objName
  **/
  @ApiModelProperty(value = "null")
  public String getObjName() {
    return objName;
  }

  public void setObjName(String objName) {
    this.objName = objName;
  }

  @JsonIgnore
  public MsBusinessObjBean objDesc(String objDesc) {
    this.objDesc = objDesc;
    return this;
  }

   /**
   * null
   * @return objDesc
  **/
  @ApiModelProperty(value = "null")
  public String getObjDesc() {
    return objDesc;
  }

  public void setObjDesc(String objDesc) {
    this.objDesc = objDesc;
  }

  @JsonIgnore
  public MsBusinessObjBean objType(String objType) {
    this.objType = objType;
    return this;
  }

   /**
   * 房地产 酒店等业务类型 为中文描述
   * @return objType
  **/
  @ApiModelProperty(value = "房地产 酒店等业务类型 为中文描述")
  public String getObjType() {
    return objType;
  }

  public void setObjType(String objType) {
    this.objType = objType;
  }

  @JsonIgnore
  public MsBusinessObjBean groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 公司ID
   * @return groupId
  **/
  @ApiModelProperty(value = "公司ID")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsBusinessObjBean items(List<MsBusinessObjMetadataBean> items) {
    this.items = items;
    return this;
  }

  public MsBusinessObjBean addItemsItem(MsBusinessObjMetadataBean itemsItem) {
    this.items.add(itemsItem);
    return this;
  }

   /**
   * 元数据明细列表
   * @return items
  **/
  @ApiModelProperty(value = "元数据明细列表")
  public List<MsBusinessObjMetadataBean> getItems() {
    return items;
  }

  public void setItems(List<MsBusinessObjMetadataBean> items) {
    this.items = items;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsBusinessObjBean businessObjBean = (MsBusinessObjBean) o;
    return Objects.equals(this.businessObjId, businessObjBean.businessObjId) &&
        Objects.equals(this.objCode, businessObjBean.objCode) &&
        Objects.equals(this.objName, businessObjBean.objName) &&
        Objects.equals(this.objDesc, businessObjBean.objDesc) &&
        Objects.equals(this.objType, businessObjBean.objType) &&
        Objects.equals(this.groupId, businessObjBean.groupId) &&
        Objects.equals(this.items, businessObjBean.items);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessObjId, objCode, objName, objDesc, objType, groupId, items);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsBusinessObjBean {\n");
    
    sb.append("    businessObjId: ").append(toIndentedString(businessObjId)).append("\n");
    sb.append("    objCode: ").append(toIndentedString(objCode)).append("\n");
    sb.append("    objName: ").append(toIndentedString(objName)).append("\n");
    sb.append("    objDesc: ").append(toIndentedString(objDesc)).append("\n");
    sb.append("    objType: ").append(toIndentedString(objType)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
