package com.xforceplus.seller.config.client.model;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 标准请求头
 */
@ApiModel(description = "标准请求头")

@JsonInclude(NON_NULL)
public class MsCompanyInfo implements Serializable {
  @JsonProperty("organizationId")
  private Long organizationId = null;

  @JsonProperty("organizationName")
  private String organizationName = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("tenantName")
  private String tenantName = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("taxNo")
  private String taxNo = null;

  private List<String> taxNos = null;

  @JsonIgnore
  public MsCompanyInfo organizationId(Long organizationId) {
    this.organizationId = organizationId;
    return this;
  }

   /**
   * 组织id
   * @return organizationId
  **/
  @ApiModelProperty(value = "组织id")
  public Long getOrganizationId() {
    return organizationId;
  }

  public void setOrganizationId(Long organizationId) {
    this.organizationId = organizationId;
  }

  @JsonIgnore
  public MsCompanyInfo organizationName(String organizationName) {
    this.organizationName = organizationName;
    return this;
  }

   /**
   * 组织名称
   * @return organizationName
  **/
  @ApiModelProperty(value = "组织名称")
  public String getOrganizationName() {
    return organizationName;
  }

  public void setOrganizationName(String organizationName) {
    this.organizationName = organizationName;
  }

  @JsonIgnore
  public MsCompanyInfo tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public MsCompanyInfo tenantName(String tenantName) {
    this.tenantName = tenantName;
    return this;
  }

   /**
   * 租户名称
   * @return tenantName
  **/
  @ApiModelProperty(value = "租户名称")
  public String getTenantName() {
    return tenantName;
  }

  public void setTenantName(String tenantName) {
    this.tenantName = tenantName;
  }

  @JsonIgnore
  public MsCompanyInfo companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司id
   * @return companyId
  **/
  @ApiModelProperty(value = "公司id")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsCompanyInfo companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsCompanyInfo taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 纳税人识别号
   * @return taxNo
  **/
  @ApiModelProperty(value = "纳税人识别号")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  /**
   * 纳税人识别号集合
   * @return taxNos
   **/
  @ApiModelProperty(value = "纳税人识别号集合")
  public List<String> getTaxNos() {
    return taxNos;
  }

  public void setTaxNos(List<String> taxNos) {
    this.taxNos = taxNos;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCompanyInfo companyInfo = (MsCompanyInfo) o;
    return Objects.equals(this.organizationId, companyInfo.organizationId) &&
        Objects.equals(this.organizationName, companyInfo.organizationName) &&
        Objects.equals(this.tenantId, companyInfo.tenantId) &&
        Objects.equals(this.tenantName, companyInfo.tenantName) &&
        Objects.equals(this.companyId, companyInfo.companyId) &&
        Objects.equals(this.companyName, companyInfo.companyName) &&
        Objects.equals(this.taxNo, companyInfo.taxNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(organizationId, organizationName, tenantId, tenantName, companyId, companyName, taxNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCompanyInfo {\n");
    
    sb.append("    organizationId: ").append(toIndentedString(organizationId)).append("\n");
    sb.append("    organizationName: ").append(toIndentedString(organizationName)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    tenantName: ").append(toIndentedString(tenantName)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
