package com.xforceplus.seller.config.client.model;

import java.io.Serializable;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.seller.config.client.parse.bean.SysInfoRuleDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsConfigBean implements Serializable {
  @JsonProperty("isDefaultRule")
  private boolean isDefaultRule = false;

  @JsonProperty("configId")
  private Long configId = null;

  @JsonProperty("configType")
  private Integer configType = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("businessBillType")
  private String businessBillType = null;

  @JsonProperty("salesbillType")
  private String salesbillType = null;

  @JsonProperty("sellerGroupId")
  private Long sellerGroupId = null;

  private String sellerOrgType = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerNo")
  private String sellerNo = null;

  @JsonProperty("taxInvoiceSource")
  private String taxInvoiceSource = null;

  @JsonProperty("sysOrgId")
  private Long sysOrgId = 0L;

  @JsonProperty("sysOrgCode")
  private String sysOrgCode ;

  @JsonProperty("purchaserGroupId")
  private Long purchaserGroupId = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserNo")
  private String purchaserNo = null;

  @JsonProperty("sellerPurchaserHashKey")
  private String sellerPurchaserHashKey = null;

  @JsonProperty("configName")
  private String configName = null;

  @JsonProperty("version")
  private Integer version = null;

  @JsonProperty("createUser")
  private Long createUser = null;

  @JsonProperty("md5")
  private String md5 = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonProperty("ext1")
  private String ext1 = null;

  @JsonProperty("ext2")
  private String ext2 = null;

  @JsonProperty("ext3")
  private String ext3 = null;

  @JsonProperty("ext4")
  private String ext4 = null;

  @JsonProperty("ext5")
  private String ext5 = null;

  @JsonProperty("ext6")
  private String ext6 = null;

  @JsonProperty("ext7")
  private String ext7 = null;

  @JsonProperty("ext8")
  private String ext8 = null;

  @JsonProperty("ext9")
  private String ext9 = null;

  @JsonProperty("ext10")
  private String ext10 = null;

  @JsonProperty("ext11")
  private String ext11 = null;

  @JsonProperty("ext12")
  private String ext12 = null;

  @JsonProperty("ext13")
  private String ext13 = null;

  @JsonProperty("ext14")
  private String ext14 = null;

  @JsonProperty("ext15")
  private String ext15 = null;

  @JsonProperty("ext16")
  private String ext16 = null;

  @JsonProperty("ext17")
  private String ext17 = null;

  @JsonProperty("ext18")
  private String ext18 = null;

  @JsonProperty("ext19")
  private String ext19 = null;

  @JsonProperty("ext20")
  private String ext20 = null;

  @JsonProperty("ext21")
  private String ext21 = null;

  @JsonProperty("ext22")
  private String ext22 = null;

  @JsonProperty("ext23")
  private String ext23 = null;

  @JsonProperty("ext24")
  private String ext24 = null;

  @JsonProperty("ext25")
  private String ext25 = null;

  @JsonProperty("itemList")
  private List<MsConfigItemBean> itemList = new ArrayList<MsConfigItemBean>();

  @JsonProperty("attributes")
  private List<MsConfigBizBillAttribute> attributes = new ArrayList<MsConfigBizBillAttribute>();

  @JsonProperty("sysInfoRuleDTO")
  private SysInfoRuleDTO sysInfoRuleDTO;

  // 是否拥有属性级别规则配置, 便于快速匹配规则
  // Caution: 1. 目前的规则机制实在很难维护, 建议后期改用关联配置表的设计思路重新设计.
  //          2. 建议抽象规则引擎模块用于处理规则匹配, 便于业务与规则计算解耦.
  @JsonProperty("hasAttrClassCfg")
  boolean hasAttrClassCfg = false;

  /** 邮件推送规则 */
  @JsonProperty("mailRule")
  private MsConfigMailRule mailRule;

  //操作类型，新增/修改
  @JsonProperty("operationFlag")
  private String operationFlag = null;

  /**
   * 票面转换规则生成的脚本
   */
  private String script;

  /**
  * 组织名称
  */
  @Getter
  @Setter
  private String sysOrgName;

  @JsonIgnore
  public MsConfigBean configId(Long configId) {
    this.configId = configId;
    return this;
  }

  public boolean isDefaultRule() {
    return isDefaultRule;
  }

  public void setDefaultRule(boolean defaultRule) {
    isDefaultRule = defaultRule;
  }

  public SysInfoRuleDTO getSysInfoRuleDTO() {
    return sysInfoRuleDTO;
  }

  public void setSysInfoRuleDTO(SysInfoRuleDTO sysInfoRuleDTO) {
    this.sysInfoRuleDTO = sysInfoRuleDTO;
  }

  public boolean isHasAttrClassCfg() {
    return hasAttrClassCfg;
  }

  public void setHasAttrClassCfg(boolean hasAttrClassCfg) {
    this.hasAttrClassCfg = hasAttrClassCfg;
  }

  /**
   * 配置主键ID
   * @return configId
  **/
  @ApiModelProperty(value = "配置主键ID")
  public Long getConfigId() {
    return configId;
  }

  public void setConfigId(Long configId) {
    this.configId = configId;
  }

  public String getSellerOrgType() {
    return sellerOrgType;
  }

  public void setSellerOrgType(String sellerOrgType) {
    this.sellerOrgType = sellerOrgType;
  }

  @JsonIgnore
  public MsConfigBean configType(Integer configType) {
    this.configType = configType;
    return this;
  }

  @ApiModelProperty(value = "业务单属性列表")
  public List<MsConfigBizBillAttribute> getAttributes() {
    return attributes;
  }

  public void setAttributes(List<MsConfigBizBillAttribute> attributes) {
    this.attributes = attributes;
  }

  /**
   * 配置类型，1：拆票规则 2：拆合规则 3 票面信息规则 4 票面人员规则 5 业务流程规则
   * @return configType
  **/
  @ApiModelProperty(value = "配置类型，1：拆票规则 2：拆合规则 3 票面信息规则 4 票面人员规则 5 业务流程规则")
  public Integer getConfigType() {
    return configType;
  }

  public void setConfigType(Integer configType) {
    this.configType = configType;
  }

  @JsonIgnore
  public MsConfigBean invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public MsConfigBean businessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
    return this;
  }

   /**
   * AR 销方            AP 购方 AP 购方
   * @return businessBillType
  **/
  @ApiModelProperty(value = "AR 销方            AP 购方 AP 购方")
  public String getBusinessBillType() {
    return businessBillType;
  }

  public void setBusinessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
  }

  @JsonIgnore
  public MsConfigBean salesbillType(String salesbillType) {
    this.salesbillType = salesbillType;
    return this;
  }

   /**
   * 单据类型
   * @return salesbillType
  **/
  @ApiModelProperty(value = "单据类型")
  public String getSalesbillType() {
    return salesbillType;
  }

  public void setSalesbillType(String salesbillType) {
    this.salesbillType = salesbillType;
  }

  @JsonIgnore
  public MsConfigBean sellerGroupId(Long sellerGroupId) {
    this.sellerGroupId = sellerGroupId;
    return this;
  }

   /**
   * 销方租户id
   * @return sellerGroupId
  **/
  @ApiModelProperty(value = "销方租户id")
  public Long getSellerGroupId() {
    return sellerGroupId;
  }

  public void setSellerGroupId(Long sellerGroupId) {
    this.sellerGroupId = sellerGroupId;
  }

  @JsonIgnore
  public MsConfigBean sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public MsConfigBean sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

  public String getTaxInvoiceSource() {
    return taxInvoiceSource;
  }

  public void setTaxInvoiceSource(String taxInvoiceSource) {
    this.taxInvoiceSource = taxInvoiceSource;
  }

  /**
   * 销方税号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public MsConfigBean sellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
    return this;
  }

   /**
   * null
   * @return sellerNo
  **/
  @ApiModelProperty(value = "null")
  public String getSellerNo() {
    return sellerNo;
  }

  public void setSellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
  }

  @JsonIgnore
  public MsConfigBean sysOrgId(Long sysOrgId) {
    this.sysOrgId = sysOrgId;
    return this;
  }

  /**
   * 销方子组织id
   * @return sysOrgId
   **/
  @ApiModelProperty(value = "销方子组织id")
  public Long getSysOrgId() {
    return sysOrgId;
  }

  public void setSysOrgId(Long getSysOrgId) {
    this.sysOrgId = getSysOrgId;
  }

  public String getSysOrgCode() {
    return sysOrgCode;
  }

  public void setSysOrgCode(String sysOrgCode) {
    this.sysOrgCode = sysOrgCode;
  }

  @JsonIgnore
  public MsConfigBean purchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
    return this;
  }

   /**
   * 购方集团ID
   * @return purchaserGroupId
  **/
  @ApiModelProperty(value = "购方集团ID")
  public Long getPurchaserGroupId() {
    return purchaserGroupId;
  }

  public void setPurchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
  }

  @JsonIgnore
  public MsConfigBean purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方集团名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方集团名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public MsConfigBean purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方集团税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方集团税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsConfigBean purchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
    return this;
  }

   /**
   * null
   * @return purchaserNo
  **/
  @ApiModelProperty(value = "null")
  public String getPurchaserNo() {
    return purchaserNo;
  }

  public void setPurchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
  }

  @JsonIgnore
  public MsConfigBean sellerPurchaserHashKey(String sellerPurchaserHashKey) {
    this.sellerPurchaserHashKey = sellerPurchaserHashKey;
    return this;
  }

   /**
   * null
   * @return sellerPurchaserHashKey
  **/
  @ApiModelProperty(value = "null")
  public String getSellerPurchaserHashKey() {
    return sellerPurchaserHashKey;
  }

  public void setSellerPurchaserHashKey(String sellerPurchaserHashKey) {
    this.sellerPurchaserHashKey = sellerPurchaserHashKey;
  }

  @JsonIgnore
  public MsConfigBean configName(String configName) {
    this.configName = configName;
    return this;
  }

   /**
   * 配置名称
   * @return configName
  **/
  @ApiModelProperty(value = "配置名称")
  public String getConfigName() {
    return configName;
  }

  public void setConfigName(String configName) {
    this.configName = configName;
  }

  @JsonIgnore
  public MsConfigBean version(Integer version) {
    this.version = version;
    return this;
  }

   /**
   * null
   * @return version
  **/
  @ApiModelProperty(value = "null")
  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer version) {
    this.version = version;
  }

  @JsonIgnore
  public MsConfigBean createUser(Long createUser) {
    this.createUser = createUser;
    return this;
  }

   /**
   * 创建人
   * @return createUser
  **/
  @ApiModelProperty(value = "创建人")
  public Long getCreateUser() {
    return createUser;
  }

  public void setCreateUser(Long createUser) {
    this.createUser = createUser;
  }

  @JsonIgnore
  public MsConfigBean md5(String md5) {
    this.md5 = md5;
    return this;
  }

   /**
   * 主信息及拓展字段的MD5值 唯一索引
   * @return md5
  **/
  @ApiModelProperty(value = "主信息及拓展字段的MD5值 唯一索引")
  public String getMd5() {
    return md5;
  }

  public void setMd5(String md5) {
    this.md5 = md5;
  }

  @JsonIgnore
  public MsConfigBean status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @ApiModelProperty(value = "")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsConfigBean createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * null
   * @return createTime
  **/
  @ApiModelProperty(value = "null")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsConfigBean updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * null
   * @return updateTime
  **/
  @ApiModelProperty(value = "null")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  @JsonIgnore
  public MsConfigBean ext1(String ext1) {
    this.ext1 = ext1;
    return this;
  }

   /**
   * null
   * @return ext1
  **/
  @ApiModelProperty(value = "null")
  public String getExt1() {
    return ext1;
  }

  public void setExt1(String ext1) {
    this.ext1 = ext1;
  }

  @JsonIgnore
  public MsConfigBean ext2(String ext2) {
    this.ext2 = ext2;
    return this;
  }

   /**
   * null
   * @return ext2
  **/
  @ApiModelProperty(value = "null")
  public String getExt2() {
    return ext2;
  }

  public void setExt2(String ext2) {
    this.ext2 = ext2;
  }

  @JsonIgnore
  public MsConfigBean ext3(String ext3) {
    this.ext3 = ext3;
    return this;
  }

   /**
   * null
   * @return ext3
  **/
  @ApiModelProperty(value = "null")
  public String getExt3() {
    return ext3;
  }

  public void setExt3(String ext3) {
    this.ext3 = ext3;
  }

  @JsonIgnore
  public MsConfigBean ext4(String ext4) {
    this.ext4 = ext4;
    return this;
  }

   /**
   * null
   * @return ext4
  **/
  @ApiModelProperty(value = "null")
  public String getExt4() {
    return ext4;
  }

  public void setExt4(String ext4) {
    this.ext4 = ext4;
  }

  @JsonIgnore
  public MsConfigBean ext5(String ext5) {
    this.ext5 = ext5;
    return this;
  }

   /**
   * null
   * @return ext5
  **/
  @ApiModelProperty(value = "null")
  public String getExt5() {
    return ext5;
  }

  public void setExt5(String ext5) {
    this.ext5 = ext5;
  }

  @JsonIgnore
  public MsConfigBean ext6(String ext6) {
    this.ext6 = ext6;
    return this;
  }

   /**
   * null
   * @return ext6
  **/
  @ApiModelProperty(value = "null")
  public String getExt6() {
    return ext6;
  }

  public void setExt6(String ext6) {
    this.ext6 = ext6;
  }

  @JsonIgnore
  public MsConfigBean ext7(String ext7) {
    this.ext7 = ext7;
    return this;
  }

   /**
   * null
   * @return ext7
  **/
  @ApiModelProperty(value = "null")
  public String getExt7() {
    return ext7;
  }

  public void setExt7(String ext7) {
    this.ext7 = ext7;
  }

  @JsonIgnore
  public MsConfigBean ext8(String ext8) {
    this.ext8 = ext8;
    return this;
  }

   /**
   * null
   * @return ext8
  **/
  @ApiModelProperty(value = "null")
  public String getExt8() {
    return ext8;
  }

  public void setExt8(String ext8) {
    this.ext8 = ext8;
  }

  @JsonIgnore
  public MsConfigBean ext9(String ext9) {
    this.ext9 = ext9;
    return this;
  }

   /**
   * null
   * @return ext9
  **/
  @ApiModelProperty(value = "null")
  public String getExt9() {
    return ext9;
  }

  public void setExt9(String ext9) {
    this.ext9 = ext9;
  }

  @JsonIgnore
  public MsConfigBean ext10(String ext10) {
    this.ext10 = ext10;
    return this;
  }

   /**
   * null
   * @return ext10
  **/
  @ApiModelProperty(value = "null")
  public String getExt10() {
    return ext10;
  }

  public void setExt10(String ext10) {
    this.ext10 = ext10;
  }

  @JsonIgnore
  public MsConfigBean ext11(String ext11) {
    this.ext11 = ext11;
    return this;
  }

   /**
   * null
   * @return ext11
  **/
  @ApiModelProperty(value = "null")
  public String getExt11() {
    return ext11;
  }

  public void setExt11(String ext11) {
    this.ext11 = ext11;
  }

  @JsonIgnore
  public MsConfigBean ext12(String ext12) {
    this.ext12 = ext12;
    return this;
  }

   /**
   * null
   * @return ext12
  **/
  @ApiModelProperty(value = "null")
  public String getExt12() {
    return ext12;
  }

  public void setExt12(String ext12) {
    this.ext12 = ext12;
  }

  @JsonIgnore
  public MsConfigBean ext13(String ext13) {
    this.ext13 = ext13;
    return this;
  }

   /**
   * null
   * @return ext13
  **/
  @ApiModelProperty(value = "null")
  public String getExt13() {
    return ext13;
  }

  public void setExt13(String ext13) {
    this.ext13 = ext13;
  }

  @JsonIgnore
  public MsConfigBean ext14(String ext14) {
    this.ext14 = ext14;
    return this;
  }

   /**
   * null
   * @return ext14
  **/
  @ApiModelProperty(value = "null")
  public String getExt14() {
    return ext14;
  }

  public void setExt14(String ext14) {
    this.ext14 = ext14;
  }

  @JsonIgnore
  public MsConfigBean ext15(String ext15) {
    this.ext15 = ext15;
    return this;
  }

   /**
   * null
   * @return ext15
  **/
  @ApiModelProperty(value = "null")
  public String getExt15() {
    return ext15;
  }

  public void setExt15(String ext15) {
    this.ext15 = ext15;
  }

  @JsonIgnore
  public MsConfigBean ext16(String ext16) {
    this.ext16 = ext16;
    return this;
  }

   /**
   * null
   * @return ext16
  **/
  @ApiModelProperty(value = "null")
  public String getExt16() {
    return ext16;
  }

  public void setExt16(String ext16) {
    this.ext16 = ext16;
  }

  @JsonIgnore
  public MsConfigBean ext17(String ext17) {
    this.ext17 = ext17;
    return this;
  }

   /**
   * null
   * @return ext17
  **/
  @ApiModelProperty(value = "null")
  public String getExt17() {
    return ext17;
  }

  public void setExt17(String ext17) {
    this.ext17 = ext17;
  }

  @JsonIgnore
  public MsConfigBean ext18(String ext18) {
    this.ext18 = ext18;
    return this;
  }

   /**
   * null
   * @return ext18
  **/
  @ApiModelProperty(value = "null")
  public String getExt18() {
    return ext18;
  }

  public void setExt18(String ext18) {
    this.ext18 = ext18;
  }

  @JsonIgnore
  public MsConfigBean ext19(String ext19) {
    this.ext19 = ext19;
    return this;
  }

   /**
   * null
   * @return ext19
  **/
  @ApiModelProperty(value = "null")
  public String getExt19() {
    return ext19;
  }

  public void setExt19(String ext19) {
    this.ext19 = ext19;
  }

  @JsonIgnore
  public MsConfigBean ext20(String ext20) {
    this.ext20 = ext20;
    return this;
  }

   /**
   * null
   * @return ext20
  **/
  @ApiModelProperty(value = "null")
  public String getExt20() {
    return ext20;
  }

  public void setExt20(String ext20) {
    this.ext20 = ext20;
  }

  @JsonIgnore
  public MsConfigBean ext21(String ext21) {
    this.ext21 = ext21;
    return this;
  }

   /**
   * null
   * @return ext21
  **/
  @ApiModelProperty(value = "null")
  public String getExt21() {
    return ext21;
  }

  public void setExt21(String ext21) {
    this.ext21 = ext21;
  }

  @JsonIgnore
  public MsConfigBean ext22(String ext22) {
    this.ext22 = ext22;
    return this;
  }

   /**
   * null
   * @return ext22
  **/
  @ApiModelProperty(value = "null")
  public String getExt22() {
    return ext22;
  }

  public void setExt22(String ext22) {
    this.ext22 = ext22;
  }

  @JsonIgnore
  public MsConfigBean ext23(String ext23) {
    this.ext23 = ext23;
    return this;
  }

   /**
   * null
   * @return ext23
  **/
  @ApiModelProperty(value = "null")
  public String getExt23() {
    return ext23;
  }

  public void setExt23(String ext23) {
    this.ext23 = ext23;
  }

  @JsonIgnore
  public MsConfigBean ext24(String ext24) {
    this.ext24 = ext24;
    return this;
  }

   /**
   * null
   * @return ext24
  **/
  @ApiModelProperty(value = "null")
  public String getExt24() {
    return ext24;
  }

  public void setExt24(String ext24) {
    this.ext24 = ext24;
  }

  @JsonIgnore
  public MsConfigBean ext25(String ext25) {
    this.ext25 = ext25;
    return this;
  }

   /**
   * null
   * @return ext25
  **/
  @ApiModelProperty(value = "null")
  public String getExt25() {
    return ext25;
  }

  public void setExt25(String ext25) {
    this.ext25 = ext25;
  }

  @JsonIgnore
  public MsConfigBean itemList(List<MsConfigItemBean> itemList) {
    this.itemList = itemList;
    return this;
  }

  public MsConfigBean addItemListItem(MsConfigItemBean itemListItem) {
    this.itemList.add(itemListItem);
    return this;
  }

   /**
   * Get itemList
   * @return itemList
  **/
  @ApiModelProperty(value = "")
  public List<MsConfigItemBean> getItemList() {
    return itemList;
  }

  public void setItemList(List<MsConfigItemBean> itemList) {
    this.itemList = itemList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigBean configBean = (MsConfigBean) o;
    return Objects.equals(this.configId, configBean.configId) &&
        Objects.equals(this.configType, configBean.configType) &&
        Objects.equals(this.invoiceType, configBean.invoiceType) &&
        Objects.equals(this.businessBillType, configBean.businessBillType) &&
        Objects.equals(this.salesbillType, configBean.salesbillType) &&
        Objects.equals(this.sellerGroupId, configBean.sellerGroupId) &&
        Objects.equals(this.sellerName, configBean.sellerName) &&
        Objects.equals(this.sellerTaxNo, configBean.sellerTaxNo) &&
        Objects.equals(this.sellerNo, configBean.sellerNo) &&
        Objects.equals(this.sysOrgId, configBean.sysOrgId) &&
        Objects.equals(this.purchaserGroupId, configBean.purchaserGroupId) &&
        Objects.equals(this.purchaserName, configBean.purchaserName) &&
        Objects.equals(this.purchaserTaxNo, configBean.purchaserTaxNo) &&
        Objects.equals(this.purchaserNo, configBean.purchaserNo) &&
        Objects.equals(this.sellerPurchaserHashKey, configBean.sellerPurchaserHashKey) &&
        Objects.equals(this.configName, configBean.configName) &&
        Objects.equals(this.version, configBean.version) &&
        Objects.equals(this.createUser, configBean.createUser) &&
        Objects.equals(this.md5, configBean.md5) &&
        Objects.equals(this.status, configBean.status) &&
        Objects.equals(this.createTime, configBean.createTime) &&
        Objects.equals(this.updateTime, configBean.updateTime) &&
        Objects.equals(this.ext1, configBean.ext1) &&
        Objects.equals(this.ext2, configBean.ext2) &&
        Objects.equals(this.ext3, configBean.ext3) &&
        Objects.equals(this.ext4, configBean.ext4) &&
        Objects.equals(this.ext5, configBean.ext5) &&
        Objects.equals(this.ext6, configBean.ext6) &&
        Objects.equals(this.ext7, configBean.ext7) &&
        Objects.equals(this.ext8, configBean.ext8) &&
        Objects.equals(this.ext9, configBean.ext9) &&
        Objects.equals(this.ext10, configBean.ext10) &&
        Objects.equals(this.ext11, configBean.ext11) &&
        Objects.equals(this.ext12, configBean.ext12) &&
        Objects.equals(this.ext13, configBean.ext13) &&
        Objects.equals(this.ext14, configBean.ext14) &&
        Objects.equals(this.ext15, configBean.ext15) &&
        Objects.equals(this.ext16, configBean.ext16) &&
        Objects.equals(this.ext17, configBean.ext17) &&
        Objects.equals(this.ext18, configBean.ext18) &&
        Objects.equals(this.ext19, configBean.ext19) &&
        Objects.equals(this.ext20, configBean.ext20) &&
        Objects.equals(this.ext21, configBean.ext21) &&
        Objects.equals(this.ext22, configBean.ext22) &&
        Objects.equals(this.ext23, configBean.ext23) &&
        Objects.equals(this.ext24, configBean.ext24) &&
        Objects.equals(this.ext25, configBean.ext25) &&
        Objects.equals(this.itemList, configBean.itemList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(configId, configType, invoiceType, businessBillType, salesbillType, sellerGroupId, sellerName, sellerTaxNo, sellerNo, sysOrgId, purchaserGroupId, purchaserName, purchaserTaxNo, purchaserNo, sellerPurchaserHashKey, configName, version, createUser, md5, status, createTime, updateTime, ext1, ext2, ext3, ext4, ext5, ext6, ext7, ext8, ext9, ext10, ext11, ext12, ext13, ext14, ext15, ext16, ext17, ext18, ext19, ext20, ext21, ext22, ext23, ext24, ext25, itemList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigBean {\n");
    
    sb.append("    configId: ").append(toIndentedString(configId)).append("\n");
    sb.append("    configType: ").append(toIndentedString(configType)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    businessBillType: ").append(toIndentedString(businessBillType)).append("\n");
    sb.append("    salesbillType: ").append(toIndentedString(salesbillType)).append("\n");
    sb.append("    sellerGroupId: ").append(toIndentedString(sellerGroupId)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    sellerNo: ").append(toIndentedString(sellerNo)).append("\n");
    sb.append("    sysOrgId: ").append(toIndentedString(sysOrgId)).append("\n");
    sb.append("    purchaserGroupId: ").append(toIndentedString(purchaserGroupId)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    purchaserNo: ").append(toIndentedString(purchaserNo)).append("\n");
    sb.append("    sellerPurchaserHashKey: ").append(toIndentedString(sellerPurchaserHashKey)).append("\n");
    sb.append("    configName: ").append(toIndentedString(configName)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    createUser: ").append(toIndentedString(createUser)).append("\n");
    sb.append("    md5: ").append(toIndentedString(md5)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    ext1: ").append(toIndentedString(ext1)).append("\n");
    sb.append("    ext2: ").append(toIndentedString(ext2)).append("\n");
    sb.append("    ext3: ").append(toIndentedString(ext3)).append("\n");
    sb.append("    ext4: ").append(toIndentedString(ext4)).append("\n");
    sb.append("    ext5: ").append(toIndentedString(ext5)).append("\n");
    sb.append("    ext6: ").append(toIndentedString(ext6)).append("\n");
    sb.append("    ext7: ").append(toIndentedString(ext7)).append("\n");
    sb.append("    ext8: ").append(toIndentedString(ext8)).append("\n");
    sb.append("    ext9: ").append(toIndentedString(ext9)).append("\n");
    sb.append("    ext10: ").append(toIndentedString(ext10)).append("\n");
    sb.append("    ext11: ").append(toIndentedString(ext11)).append("\n");
    sb.append("    ext12: ").append(toIndentedString(ext12)).append("\n");
    sb.append("    ext13: ").append(toIndentedString(ext13)).append("\n");
    sb.append("    ext14: ").append(toIndentedString(ext14)).append("\n");
    sb.append("    ext15: ").append(toIndentedString(ext15)).append("\n");
    sb.append("    ext16: ").append(toIndentedString(ext16)).append("\n");
    sb.append("    ext17: ").append(toIndentedString(ext17)).append("\n");
    sb.append("    ext18: ").append(toIndentedString(ext18)).append("\n");
    sb.append("    ext19: ").append(toIndentedString(ext19)).append("\n");
    sb.append("    ext20: ").append(toIndentedString(ext20)).append("\n");
    sb.append("    ext21: ").append(toIndentedString(ext21)).append("\n");
    sb.append("    ext22: ").append(toIndentedString(ext22)).append("\n");
    sb.append("    ext23: ").append(toIndentedString(ext23)).append("\n");
    sb.append("    ext24: ").append(toIndentedString(ext24)).append("\n");
    sb.append("    ext25: ").append(toIndentedString(ext25)).append("\n");
    sb.append("    itemList: ").append(toIndentedString(itemList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  public MsConfigMailRule getMailRule() {
    return mailRule;
  }

  public void setMailRule(MsConfigMailRule mailRule) {
    this.mailRule = mailRule;
  }

  public String getOperationFlag() {
    return operationFlag;
  }

  public void setOperationFlag(String operationFlag) {
    this.operationFlag = operationFlag;
  }

  public String getScript() {
    return this.script;
  }

  public void setScript(String script) {
    this.script = script;
  }
}
