package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 主业务属性bean
 */
@ApiModel(description = "MsConfigBizBillAttribute")
@JsonInclude(NON_NULL)
@Data
@EqualsAndHashCode(of = {"fieldName", "value"})
public class MsConfigBizBillAttribute implements Serializable {

    @JsonProperty("configBillAttrId")
    private Long configBillAttrId;

    // 扩展字段名
    @JsonProperty("fieldName")
    private String fieldName;

    @JsonProperty("fieldType")
    private String fieldType;

    @JsonProperty("fieldValue")
    private String fieldValue;

    // 配置项名
    @JsonProperty("attrName")
    private String attrName;

    @JsonProperty("attrDesc")
    private String attrDesc;

    // tag.value
    @JsonProperty("value")
    private String value;
}
