package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsConfigDeleteRequstWithUserInfo {
  @JsonProperty("configIdList")
  private List<Long> configIdList = new ArrayList<Long>();

  @JsonProperty("userInfo")
  private MsCommonUserInfo userInfo = null;

  @JsonProperty("configType")
  private Integer configType;

  @JsonIgnore
  public MsConfigDeleteRequstWithUserInfo configIdList(List<Long> configIdList) {
    this.configIdList = configIdList;
    return this;
  }

  public MsConfigDeleteRequstWithUserInfo addConfigIdListItem(Long configIdListItem) {
    this.configIdList.add(configIdListItem);
    return this;
  }

  public Integer getConfigType() {
    return configType;
  }

  public void setConfigType(Integer configType) {
    this.configType = configType;
  }

   /**
   * 批量删除的配置ID
   * @return configIdList
  **/
  @ApiModelProperty(value = "批量删除的配置ID")
  public List<Long> getConfigIdList() {
    return configIdList;
  }

  public void setConfigIdList(List<Long> configIdList) {
    this.configIdList = configIdList;
  }

  @JsonIgnore
  public MsConfigDeleteRequstWithUserInfo userInfo(MsCommonUserInfo userInfo) {
    this.userInfo = userInfo;
    return this;
  }

   /**
   * 用户信息
   * @return userInfo
  **/
  @ApiModelProperty(value = "用户信息")
  public MsCommonUserInfo getUserInfo() {
    return userInfo;
  }

  public void setUserInfo(MsCommonUserInfo userInfo) {
    this.userInfo = userInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigDeleteRequstWithUserInfo configDeleteRequstWithUserInfo = (MsConfigDeleteRequstWithUserInfo) o;
    return Objects.equals(this.configIdList, configDeleteRequstWithUserInfo.configIdList) &&
        Objects.equals(this.userInfo, configDeleteRequstWithUserInfo.userInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(configIdList, userInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigDeleteRequstWithUserInfo {\n");
    
    sb.append("    configIdList: ").append(toIndentedString(configIdList)).append("\n");
    sb.append("    userInfo: ").append(toIndentedString(userInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
