package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsConfigItemAddRequest {
  @JsonProperty("itemDTOList")
  private List<MsConfigItemBean> itemDTOList = new ArrayList<MsConfigItemBean>();

  @JsonProperty("configId")
  private Long configId = null;

  @JsonIgnore
  public MsConfigItemAddRequest itemDTOList(List<MsConfigItemBean> itemDTOList) {
    this.itemDTOList = itemDTOList;
    return this;
  }

  public MsConfigItemAddRequest addItemDTOListItem(MsConfigItemBean itemDTOListItem) {
    this.itemDTOList.add(itemDTOListItem);
    return this;
  }

   /**
   * Get itemDTOList
   * @return itemDTOList
  **/
  @ApiModelProperty(value = "")
  public List<MsConfigItemBean> getItemDTOList() {
    return itemDTOList;
  }

  public void setItemDTOList(List<MsConfigItemBean> itemDTOList) {
    this.itemDTOList = itemDTOList;
  }

  @JsonIgnore
  public MsConfigItemAddRequest configId(Long configId) {
    this.configId = configId;
    return this;
  }

   /**
   * null
   * @return configId
  **/
  @ApiModelProperty(value = "null")
  public Long getConfigId() {
    return configId;
  }

  public void setConfigId(Long configId) {
    this.configId = configId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigItemAddRequest configItemAddRequest = (MsConfigItemAddRequest) o;
    return Objects.equals(this.itemDTOList, configItemAddRequest.itemDTOList) &&
        Objects.equals(this.configId, configItemAddRequest.configId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(itemDTOList, configId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigItemAddRequest {\n");
    
    sb.append("    itemDTOList: ").append(toIndentedString(itemDTOList)).append("\n");
    sb.append("    configId: ").append(toIndentedString(configId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
