package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsConfigItemBean implements Serializable {
  @JsonProperty("configItemId")
  private Long configItemId = null;

  @JsonProperty("configId")
  private Long configId = null;

  @JsonProperty("configItemName")
  private String configItemName = null;

  @JsonProperty("configItemDisplayName")
  private String configItemDisplayName = null;

  @JsonProperty("configItemValue")
  private List<String> configItemValue = new ArrayList<String>();

  @JsonProperty("sort")
  private Integer sort = null;


  public MsConfigItemBean(String configItemName, List<String> configItemValue, String configItemDisplayName) {
    this.configItemName = configItemName;
    this.configItemValue = configItemValue;
    this.configItemDisplayName = configItemDisplayName;
  }

  public MsConfigItemBean(String configItemName, List<String> configItemValue) {
    this.configItemName = configItemName;
    this.configItemValue = configItemValue;
  }

  public MsConfigItemBean() {
  }

  @JsonIgnore
  public MsConfigItemBean configItemId(Long configItemId) {
    this.configItemId = configItemId;
    return this;
  }

   /**
   * null
   * @return configItemId
  **/
  @ApiModelProperty(value = "null")
  public Long getConfigItemId() {
    return configItemId;
  }

  public void setConfigItemId(Long configItemId) {
    this.configItemId = configItemId;
  }

  @JsonIgnore
  public MsConfigItemBean configId(Long configId) {
    this.configId = configId;
    return this;
  }

   /**
   * 配置项id
   * @return configId
  **/
  @ApiModelProperty(value = "配置项id")
  public Long getConfigId() {
    return configId;
  }

  public void setConfigId(Long configId) {
    this.configId = configId;
  }

  @JsonIgnore
  public MsConfigItemBean configItemName(String configItemName) {
    this.configItemName = configItemName;
    return this;
  }

   /**
   * 字段名称 billNo ext1 等
   * @return configItemName
  **/
  @ApiModelProperty(value = "字段名称 billNo ext1 等")
  public String getConfigItemName() {
    return configItemName;
  }

  public void setConfigItemName(String configItemName) {
    this.configItemName = configItemName;
  }

  @JsonIgnore
  public MsConfigItemBean configItemDisplayName(String configItemDisplayName) {
    this.configItemDisplayName = configItemDisplayName;
    return this;
  }

   /**
   * null
   * @return configItemDisplayName
  **/
  @ApiModelProperty(value = "null")
  public String getConfigItemDisplayName() {
    return configItemDisplayName;
  }

  public void setConfigItemDisplayName(String configItemDisplayName) {
    this.configItemDisplayName = configItemDisplayName;
  }

  @JsonIgnore
  public MsConfigItemBean configItemValue(List<String> configItemValue) {
    this.configItemValue = configItemValue;
    return this;
  }

  public MsConfigItemBean addConfigItemValueItem(String configItemValueItem) {
    this.configItemValue.add(configItemValueItem);
    return this;
  }

   /**
   * json方式描述配置项判断规则
   * @return configItemValue
  **/
  @ApiModelProperty(value = "json方式描述配置项判断规则")
  public List<String> getConfigItemValue() {
    return configItemValue;
  }

  public void setConfigItemValue(List<String> configItemValue) {
    this.configItemValue = configItemValue;
  }

  @JsonIgnore
  public MsConfigItemBean sort(Integer sort) {
    this.sort = sort;
    return this;
  }

   /**
   * 顺序，表示 配置明细项 展示的位置
   * @return sort
  **/
  @ApiModelProperty(value = "顺序，表示 配置明细项 展示的位置")
  public Integer getSort() {
    return sort;
  }

  public void setSort(Integer sort) {
    this.sort = sort;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigItemBean configItemBean = (MsConfigItemBean) o;
    return Objects.equals(this.configItemId, configItemBean.configItemId) &&
        Objects.equals(this.configId, configItemBean.configId) &&
        Objects.equals(this.configItemName, configItemBean.configItemName) &&
        Objects.equals(this.configItemDisplayName, configItemBean.configItemDisplayName) &&
        Objects.equals(this.configItemValue, configItemBean.configItemValue) &&
        Objects.equals(this.sort, configItemBean.sort);
  }

  @Override
  public int hashCode() {
    return Objects.hash(configItemId, configId, configItemName, configItemDisplayName, configItemValue, sort);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigItemBean {\n");
    
    sb.append("    configItemId: ").append(toIndentedString(configItemId)).append("\n");
    sb.append("    configId: ").append(toIndentedString(configId)).append("\n");
    sb.append("    configItemName: ").append(toIndentedString(configItemName)).append("\n");
    sb.append("    configItemDisplayName: ").append(toIndentedString(configItemDisplayName)).append("\n");
    sb.append("    configItemValue: ").append(toIndentedString(configItemValue)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
