package com.xforceplus.seller.config.client.model;

import java.io.Serializable;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsConfigPageDTO implements Serializable {
  @JsonProperty("total")
  private Integer total = null;

  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("itemDTOList")
  private List<MsConfigBean> itemDTOList = new ArrayList<MsConfigBean>();

  @JsonIgnore
  public MsConfigPageDTO total(Integer total) {
    this.total = total;
    return this;
  }

   /**
   * 发起 1表示已受理 -1表示调用失败 查询 1表示处理完成 2表示处理中
   * @return total
  **/
  @ApiModelProperty(value = "发起 1表示已受理 -1表示调用失败 查询 1表示处理完成 2表示处理中")
  public Integer getTotal() {
    return total;
  }

  public void setTotal(Integer total) {
    this.total = total;
  }

  @JsonIgnore
  public MsConfigPageDTO pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * return message
   * @return pageNo
  **/
  @ApiModelProperty(value = "return message")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public MsConfigPageDTO itemDTOList(List<MsConfigBean> itemDTOList) {
    this.itemDTOList = itemDTOList;
    return this;
  }

  public MsConfigPageDTO addItemDTOListItem(MsConfigBean itemDTOListItem) {
    this.itemDTOList.add(itemDTOListItem);
    return this;
  }

   /**
   * Get itemDTOList
   * @return itemDTOList
  **/
  @ApiModelProperty(value = "")
  public List<MsConfigBean> getItemDTOList() {
    return itemDTOList;
  }

  public void setItemDTOList(List<MsConfigBean> itemDTOList) {
    this.itemDTOList = itemDTOList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigPageDTO configPageDTO = (MsConfigPageDTO) o;
    return Objects.equals(this.total, configPageDTO.total) &&
        Objects.equals(this.pageNo, configPageDTO.pageNo) &&
        Objects.equals(this.itemDTOList, configPageDTO.itemDTOList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total, pageNo, itemDTOList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigPageDTO {\n");
    
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    itemDTOList: ").append(toIndentedString(itemDTOList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
