package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsConfigQueryInvoiceTypeRequest
 */

@JsonInclude(NON_NULL)
public class MsConfigQueryInvoiceTypeRequest {
  @JsonProperty("id")
  private Integer id = null;

  @JsonIgnore
  public MsConfigQueryInvoiceTypeRequest id(Integer id) {
    this.id = id;
    return this;
  }

   /**
   * 不需要的参数，只为有请求参数
   * @return id
  **/
  @ApiModelProperty(value = "不需要的参数，只为有请求参数")
  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigQueryInvoiceTypeRequest configQueryInvoiceTypeRequest = (MsConfigQueryInvoiceTypeRequest) o;
    return Objects.equals(this.id, configQueryInvoiceTypeRequest.id);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigQueryInvoiceTypeRequest {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
