package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * MsConfigUpdateTerminalStatusRequest
 */

@JsonInclude(NON_NULL)
public class MsConfigUpdateTerminalStatusRequest {
  @JsonProperty("terminalId")
  private List<Long> terminalId = new ArrayList<Long>();

  @JsonProperty("terminalUn")
  private List<String> terminalUn = new ArrayList<>();

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("operateInfo")
  private MsOperateInfo operateInfo = null;

  @JsonProperty("licenseInfo")
  private MsLicenseInfo licenseInfo = null;

  public List<String> getTerminalUn() {
    return terminalUn;
  }

  public void setTerminalUn(List<String> terminalUn) {
    this.terminalUn = terminalUn;
  }

  @JsonIgnore
  public MsConfigUpdateTerminalStatusRequest terminalId(List<Long> terminalId) {
    this.terminalId = terminalId;
    return this;
  }

  public MsConfigUpdateTerminalStatusRequest addTerminalIdItem(Long terminalIdItem) {
    this.terminalId.add(terminalIdItem);
    return this;
  }

   /**
   * 终端id
   * @return terminalId
  **/
  @ApiModelProperty(value = "终端id")
  public List<Long> getTerminalId() {
    return terminalId;
  }

  public void setTerminalId(List<Long> terminalId) {
    this.terminalId = terminalId;
  }

  @JsonIgnore
  public MsConfigUpdateTerminalStatusRequest companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司id，启用的时候需要传
   * @return companyId
  **/
  @ApiModelProperty(value = "公司id，启用的时候需要传")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsConfigUpdateTerminalStatusRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：停用 22：作废）
   * @return status
  **/
  @ApiModelProperty(value = "状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：停用 22：作废）")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsConfigUpdateTerminalStatusRequest operateInfo(MsOperateInfo operateInfo) {
    this.operateInfo = operateInfo;
    return this;
  }

   /**
   * 操作信息
   * @return operateInfo
  **/
  @ApiModelProperty(value = "操作信息")
  public MsOperateInfo getOperateInfo() {
    return operateInfo;
  }

  public void setOperateInfo(MsOperateInfo operateInfo) {
    this.operateInfo = operateInfo;
  }

  @JsonIgnore
  public MsConfigUpdateTerminalStatusRequest licenseInfo(MsLicenseInfo licenseInfo) {
    this.licenseInfo = licenseInfo;
    return this;
  }

   /**
   * 授权文件信息
   * @return licenseInfo
  **/
  @ApiModelProperty(value = "授权文件信息")
  public MsLicenseInfo getLicenseInfo() {
    return licenseInfo;
  }

  public void setLicenseInfo(MsLicenseInfo licenseInfo) {
    this.licenseInfo = licenseInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigUpdateTerminalStatusRequest configUpdateTerminalStatusRequest = (MsConfigUpdateTerminalStatusRequest) o;
    return Objects.equals(this.terminalId, configUpdateTerminalStatusRequest.terminalId) &&
        Objects.equals(this.companyId, configUpdateTerminalStatusRequest.companyId) &&
        Objects.equals(this.status, configUpdateTerminalStatusRequest.status) &&
        Objects.equals(this.operateInfo, configUpdateTerminalStatusRequest.operateInfo) &&
        Objects.equals(this.licenseInfo, configUpdateTerminalStatusRequest.licenseInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(terminalId, companyId, status, operateInfo, licenseInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigUpdateTerminalStatusRequest {\n");
    
    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
    sb.append("    licenseInfo: ").append(toIndentedString(licenseInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
