package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 设备的信息
 */
@ApiModel(description = "设备的信息")

@JsonInclude(NON_NULL)
public class MsDeviceInfo implements Serializable {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("deviceUn")
  private String deviceUn = null;

  @JsonProperty("companyInfo")
  private MsCompanyInfo companyInfo = null;

  @JsonProperty("operateInfo")
  private MsOperateInfo operateInfo = null;

  @JsonProperty("deviceNo")
  private String deviceNo = null;

  @JsonProperty("deviceName")
  private String deviceName = null;

  @JsonProperty("deviceType")
  private String deviceType = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("service")
  private List<String> service = new ArrayList<String>();

  @JsonProperty("taxDeviceInfo")
  private MsTaxDeviceInfo taxDeviceInfo = null;

  @JsonProperty("extraInfo")
  private MsDeviceExtraInfo extraInfo = null;

  @JsonProperty("hasLicenseFlag")
  private Boolean hasLicenseFlag = null;

  @JsonProperty("originAccountQueueName")
  private String originAccountQueueName = null;

  @JsonProperty("queueName")
  private String queueName = null;

  @JsonProperty("status")
  private Integer status = null;


  public String getDeviceUn() {
    return deviceUn;
  }

  public void setDeviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
  }

  @JsonIgnore
  public MsDeviceInfo id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 设备id，查询时返回
   * @return id
  **/
  @ApiModelProperty(value = "设备id，查询时返回")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsDeviceInfo companyInfo(MsCompanyInfo companyInfo) {
    this.companyInfo = companyInfo;
    return this;
  }

   /**
   * 公司信息
   * @return companyInfo
  **/
  @ApiModelProperty(value = "公司信息")
  public MsCompanyInfo getCompanyInfo() {
    return companyInfo;
  }

  public void setCompanyInfo(MsCompanyInfo companyInfo) {
    this.companyInfo = companyInfo;
  }

  @JsonIgnore
  public MsDeviceInfo operateInfo(MsOperateInfo operateInfo) {
    this.operateInfo = operateInfo;
    return this;
  }

   /**
   * 操作信息
   * @return operateInfo
  **/
  @ApiModelProperty(value = "操作信息")
  public MsOperateInfo getOperateInfo() {
    return operateInfo;
  }

  public void setOperateInfo(MsOperateInfo operateInfo) {
    this.operateInfo = operateInfo;
  }

  @JsonIgnore
  public MsDeviceInfo deviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
    return this;
  }

   /**
   * 设备编号
   * @return deviceNo
  **/
  @ApiModelProperty(value = "设备编号")
  public String getDeviceNo() {
    return deviceNo;
  }

  public void setDeviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
  }

  @JsonIgnore
  public MsDeviceInfo deviceName(String deviceName) {
    this.deviceName = deviceName;
    return this;
  }

   /**
   * 设备名称
   * @return deviceName
  **/
  @ApiModelProperty(value = "设备名称")
  public String getDeviceName() {
    return deviceName;
  }

  public void setDeviceName(String deviceName) {
    this.deviceName = deviceName;
  }

  @JsonIgnore
  public MsDeviceInfo deviceType(String deviceType) {
    this.deviceType = deviceType;
    return this;
  }

   /**
   * (必须)设备类型，taxDevice：税控设备，UKey：UKey
   * @return deviceType
  **/
  @ApiModelProperty(value = "(必须)设备类型，taxDevice：税控设备，UKey：UKey")
  public String getDeviceType() {
    return deviceType;
  }

  public void setDeviceType(String deviceType) {
    this.deviceType = deviceType;
  }

  @JsonIgnore
  public MsDeviceInfo remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/
  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public MsDeviceInfo service(List<String> service) {
    this.service = service;
    return this;
  }

  public MsDeviceInfo addServiceItem(String serviceItem) {
    this.service.add(serviceItem);
    return this;
  }

   /**
   * 支持的服务 （make：开票 ，print：打印，originAccount：底账）
   * @return service
  **/
  @ApiModelProperty(value = "支持的服务 （make：开票 ，print：打印，originAccount：底账）")
  public List<String> getService() {
    return service;
  }

  public void setService(List<String> service) {
    this.service = service;
  }

  @JsonIgnore
  public MsDeviceInfo taxDeviceInfo(MsTaxDeviceInfo taxDeviceInfo) {
    this.taxDeviceInfo = taxDeviceInfo;
    return this;
  }

   /**
   * 税控设备消息
   * @return taxDeviceInfo
  **/
  @ApiModelProperty(value = "税控设备消息")
  public MsTaxDeviceInfo getTaxDeviceInfo() {
    return taxDeviceInfo;
  }

  public void setTaxDeviceInfo(MsTaxDeviceInfo taxDeviceInfo) {
    this.taxDeviceInfo = taxDeviceInfo;
  }

  @JsonIgnore
  public MsDeviceInfo extraInfo(MsDeviceExtraInfo extraInfo) {
    this.extraInfo = extraInfo;
    return this;
  }

   /**
   * 配置信息
   * @return extraInfo
  **/
  @ApiModelProperty(value = "配置信息")
  public MsDeviceExtraInfo getExtraInfo() {
    return extraInfo;
  }

  public void setExtraInfo(MsDeviceExtraInfo extraInfo) {
    this.extraInfo = extraInfo;
  }

  @JsonIgnore
  public MsDeviceInfo hasLicenseFlag(Boolean hasLicenseFlag) {
    this.hasLicenseFlag = hasLicenseFlag;
    return this;
  }

   /**
   * 是否有授权文件,查询时返回
   * @return hasLicenseFlag
  **/
  @ApiModelProperty(value = "是否有授权文件,查询时返回")
  public Boolean getHasLicenseFlag() {
    return hasLicenseFlag;
  }

  public void setHasLicenseFlag(Boolean hasLicenseFlag) {
    this.hasLicenseFlag = hasLicenseFlag;
  }

  @JsonIgnore
  public MsDeviceInfo originAccountQueueName(String originAccountQueueName) {
    this.originAccountQueueName = originAccountQueueName;
    return this;
  }

   /**
   * 底账监听的队列，查询时返回
   * @return originAccountQueueName
  **/
  @ApiModelProperty(value = "底账监听的队列，查询时返回")
  public String getOriginAccountQueueName() {
    return originAccountQueueName;
  }

  public void setOriginAccountQueueName(String originAccountQueueName) {
    this.originAccountQueueName = originAccountQueueName;
  }

  @JsonIgnore
  public MsDeviceInfo queueName(String queueName) {
    this.queueName = queueName;
    return this;
  }

   /**
   * 开票设备监听的队列，查询时返回
   * @return queueName
  **/
  @ApiModelProperty(value = "开票设备监听的队列，查询时返回")
  public String getQueueName() {
    return queueName;
  }

  public void setQueueName(String queueName) {
    this.queueName = queueName;
  }

  @JsonIgnore
  public MsDeviceInfo status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 设备状态（0：待审核 1:审核通过 2：审核失败 11：启用 12：未启用 21：关闭 22：作废）
   * @return status
  **/
  @ApiModelProperty(value = "设备状态（0：待审核 1:审核通过 2：审核失败 11：启用 12：未启用 21：关闭 22：作废）")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsDeviceInfo deviceInfo = (MsDeviceInfo) o;
    return Objects.equals(this.id, deviceInfo.id) &&
        Objects.equals(this.companyInfo, deviceInfo.companyInfo) &&
        Objects.equals(this.operateInfo, deviceInfo.operateInfo) &&
        Objects.equals(this.deviceNo, deviceInfo.deviceNo) &&
        Objects.equals(this.deviceName, deviceInfo.deviceName) &&
        Objects.equals(this.deviceType, deviceInfo.deviceType) &&
        Objects.equals(this.remark, deviceInfo.remark) &&
        Objects.equals(this.service, deviceInfo.service) &&
        Objects.equals(this.taxDeviceInfo, deviceInfo.taxDeviceInfo) &&
        Objects.equals(this.extraInfo, deviceInfo.extraInfo) &&
        Objects.equals(this.hasLicenseFlag, deviceInfo.hasLicenseFlag) &&
        Objects.equals(this.originAccountQueueName, deviceInfo.originAccountQueueName) &&
        Objects.equals(this.queueName, deviceInfo.queueName) &&
        Objects.equals(this.status, deviceInfo.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, companyInfo, operateInfo, deviceNo, deviceName, deviceType, remark, service, taxDeviceInfo, extraInfo, hasLicenseFlag, originAccountQueueName, queueName, status);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsDeviceInfo {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    companyInfo: ").append(toIndentedString(companyInfo)).append("\n");
    sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
    sb.append("    deviceNo: ").append(toIndentedString(deviceNo)).append("\n");
    sb.append("    deviceName: ").append(toIndentedString(deviceName)).append("\n");
    sb.append("    deviceType: ").append(toIndentedString(deviceType)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    service: ").append(toIndentedString(service)).append("\n");
    sb.append("    taxDeviceInfo: ").append(toIndentedString(taxDeviceInfo)).append("\n");
    sb.append("    extraInfo: ").append(toIndentedString(extraInfo)).append("\n");
    sb.append("    hasLicenseFlag: ").append(toIndentedString(hasLicenseFlag)).append("\n");
    sb.append("    originAccountQueueName: ").append(toIndentedString(originAccountQueueName)).append("\n");
    sb.append("    queueName: ").append(toIndentedString(queueName)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
