package com.xforceplus.seller.config.client.model;

import java.io.Serializable;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsMetaDataSummaryDTO implements Serializable {
  @JsonProperty("count")
  private Integer count = null;

  @JsonProperty("code")
  private String code = null;

  @JsonProperty("name")
  private String name = null;

  @JsonIgnore
  public MsMetaDataSummaryDTO count(Integer count) {
    this.count = count;
    return this;
  }

   /**
   * 总数量
   * @return count
  **/
  @ApiModelProperty(value = "总数量")
  public Integer getCount() {
    return count;
  }

  public void setCount(Integer count) {
    this.count = count;
  }

  @JsonIgnore
  public MsMetaDataSummaryDTO code(String code) {
    this.code = code;
    return this;
  }

   /**
   * 状态码
   * @return code
  **/
  @ApiModelProperty(value = "状态码")
  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  @JsonIgnore
  public MsMetaDataSummaryDTO name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 中文名称
   * @return name
  **/
  @ApiModelProperty(value = "中文名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsMetaDataSummaryDTO metaDataSummaryDTO = (MsMetaDataSummaryDTO) o;
    return Objects.equals(this.count, metaDataSummaryDTO.count) &&
        Objects.equals(this.code, metaDataSummaryDTO.code) &&
        Objects.equals(this.name, metaDataSummaryDTO.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(count, code, name);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsMetaDataSummaryDTO {\n");
    
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
