package com.xforceplus.seller.config.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.seller.config.client.model.MsBusinessObjMetadataBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * null
 */
@ApiModel(description = "null")

@JsonInclude(NON_NULL)
public class MsMetadataItemAddRequest {
  @JsonProperty("objId")
  private Long objId = null;

  @JsonProperty("itemDTOList")
  private List<MsBusinessObjMetadataBean> itemDTOList = new ArrayList<MsBusinessObjMetadataBean>();

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonIgnore
  public MsMetadataItemAddRequest objId(Long objId) {
    this.objId = objId;
    return this;
  }

   /**
   * 对象ID
   * @return objId
  **/
  @ApiModelProperty(value = "对象ID")
  public Long getObjId() {
    return objId;
  }

  public void setObjId(Long objId) {
    this.objId = objId;
  }

  @JsonIgnore
  public MsMetadataItemAddRequest itemDTOList(List<MsBusinessObjMetadataBean> itemDTOList) {
    this.itemDTOList = itemDTOList;
    return this;
  }

  public MsMetadataItemAddRequest addItemDTOListItem(MsBusinessObjMetadataBean itemDTOListItem) {
    this.itemDTOList.add(itemDTOListItem);
    return this;
  }

   /**
   * Get itemDTOList
   * @return itemDTOList
  **/
  @ApiModelProperty(value = "")
  public List<MsBusinessObjMetadataBean> getItemDTOList() {
    return itemDTOList;
  }

  public void setItemDTOList(List<MsBusinessObjMetadataBean> itemDTOList) {
    this.itemDTOList = itemDTOList;
  }

  @JsonIgnore
  public MsMetadataItemAddRequest updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsMetadataItemAddRequest metadataItemAddRequest = (MsMetadataItemAddRequest) o;
    return Objects.equals(this.objId, metadataItemAddRequest.objId) &&
        Objects.equals(this.itemDTOList, metadataItemAddRequest.itemDTOList) &&
        Objects.equals(this.updateTime, metadataItemAddRequest.updateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(objId, itemDTOList, updateTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsMetadataItemAddRequest {\n");
    
    sb.append("    objId: ").append(toIndentedString(objId)).append("\n");
    sb.append("    itemDTOList: ").append(toIndentedString(itemDTOList)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
