package com.xforceplus.seller.config.client.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class MsQueryTerminalRequest {
    @ApiModelProperty("发票类型")
    private List<String> invoiceType;
    @ApiModelProperty("税号")
    private String taxNo;
    @ApiModelProperty("税号集合")
    private List<String> taxNos;
    @ApiModelProperty("支持的服务 print:打印 make:开票 assistant:辅助 originAccount:底账")
    private List<String> supportService;
    @ApiModelProperty("终端唯一码")
    private List<String> terminalUns;
    @ApiModelProperty("租户id")
    private Long tenantId;
    @ApiModelProperty("终端编号")
    private String terminalNo;
    @ApiModelProperty("终端名称")
    private String terminalName;

    @ApiModelProperty("是否查询库存")
    private Boolean queryInventory;
    @ApiModelProperty("是否查询在线")
    private Boolean queryOnline;
    @ApiModelProperty("是否控制用户权限")
    private Boolean limitByUser;
}
