package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 终端信息
 */
@ApiModel(description = "终端信息")

@JsonInclude(NON_NULL)
public class MsTerminalQueryInfo {
  @JsonProperty("terminalIds")
  private List<Long> terminalIds = new ArrayList<Long>();

  @JsonProperty("terminalUns")
  private List<String> terminalUns = new ArrayList<>();

  @JsonProperty("companyInfo")
  private MsCompanyInfo companyInfo = null;

  @JsonProperty("terminalNo")
  private String terminalNo = null;

  @JsonProperty("terminalName")
  private String terminalName = null;

  @JsonProperty("invoiceType")
  private List<String> invoiceType = new ArrayList<String>();

  @JsonProperty("terminalType")
  private Integer terminalType = null;

  @JsonProperty("supportService")
  private List<String> supportService = new ArrayList<String>();

  @JsonProperty("status")
  private Integer status = null;

  public List<String> getTerminalUns() {
    return terminalUns;
  }

  public void setTerminalUns(List<String> terminalUns) {
    this.terminalUns = terminalUns;
  }

  @JsonIgnore
  public MsTerminalQueryInfo terminalIds(List<Long> terminalIds) {
    this.terminalIds = terminalIds;
    return this;
  }

  public MsTerminalQueryInfo addTerminalIdsItem(Long terminalIdsItem) {
    this.terminalIds.add(terminalIdsItem);
    return this;
  }

   /**
   * 终端id
   * @return terminalIds
  **/
  @ApiModelProperty(value = "终端id")
  public List<Long> getTerminalIds() {
    return terminalIds;
  }

  public void setTerminalIds(List<Long> terminalIds) {
    this.terminalIds = terminalIds;
  }

  @JsonIgnore
  public MsTerminalQueryInfo companyInfo(MsCompanyInfo companyInfo) {
    this.companyInfo = companyInfo;
    return this;
  }

   /**
   * 公司信息
   * @return companyInfo
  **/
  @ApiModelProperty(value = "公司信息")
  public MsCompanyInfo getCompanyInfo() {
    return companyInfo;
  }

  public void setCompanyInfo(MsCompanyInfo companyInfo) {
    this.companyInfo = companyInfo;
  }

  @JsonIgnore
  public MsTerminalQueryInfo terminalNo(String terminalNo) {
    this.terminalNo = terminalNo;
    return this;
  }

   /**
   * 终端编号
   * @return terminalNo
  **/
  @ApiModelProperty(value = "终端编号")
  public String getTerminalNo() {
    return terminalNo;
  }

  public void setTerminalNo(String terminalNo) {
    this.terminalNo = terminalNo;
  }

  @JsonIgnore
  public MsTerminalQueryInfo terminalName(String terminalName) {
    this.terminalName = terminalName;
    return this;
  }

   /**
   * 终端名称
   * @return terminalName
  **/
  @ApiModelProperty(value = "终端名称")
  public String getTerminalName() {
    return terminalName;
  }

  public void setTerminalName(String terminalName) {
    this.terminalName = terminalName;
  }

  @JsonIgnore
  public MsTerminalQueryInfo invoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

  public MsTerminalQueryInfo addInvoiceTypeItem(String invoiceTypeItem) {
    this.invoiceType.add(invoiceTypeItem);
    return this;
  }

   /**
   * 发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）")
  public List<String> getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public MsTerminalQueryInfo terminalType(Integer terminalType) {
    this.terminalType = terminalType;
    return this;
  }

   /**
   * 终端类型 1：单盘 2：服务器
   * @return terminalType
  **/
  @ApiModelProperty(value = "终端类型 1：单盘 2：服务器")
  public Integer getTerminalType() {
    return terminalType;
  }

  public void setTerminalType(Integer terminalType) {
    this.terminalType = terminalType;
  }

  @JsonIgnore
  public MsTerminalQueryInfo supportService(List<String> supportService) {
    this.supportService = supportService;
    return this;
  }

  public MsTerminalQueryInfo addSupportServiceItem(String supportServiceItem) {
    this.supportService.add(supportServiceItem);
    return this;
  }

   /**
   * 支持的服务（print:打印 make:开票,originAccount:底账）
   * @return supportService
  **/
  @ApiModelProperty(value = "支持的服务（print:打印 make:开票,originAccount:底账）")
  public List<String> getSupportService() {
    return supportService;
  }

  public void setSupportService(List<String> supportService) {
    this.supportService = supportService;
  }

  @JsonIgnore
  public MsTerminalQueryInfo status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：停用 ）
   * @return status
  **/
  @ApiModelProperty(value = "状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：停用 ）")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTerminalQueryInfo terminalQueryInfo = (MsTerminalQueryInfo) o;
    return Objects.equals(this.terminalIds, terminalQueryInfo.terminalIds) &&
        Objects.equals(this.companyInfo, terminalQueryInfo.companyInfo) &&
        Objects.equals(this.terminalNo, terminalQueryInfo.terminalNo) &&
        Objects.equals(this.terminalName, terminalQueryInfo.terminalName) &&
        Objects.equals(this.invoiceType, terminalQueryInfo.invoiceType) &&
        Objects.equals(this.terminalType, terminalQueryInfo.terminalType) &&
        Objects.equals(this.supportService, terminalQueryInfo.supportService) &&
        Objects.equals(this.status, terminalQueryInfo.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(terminalIds, companyInfo, terminalNo, terminalName, invoiceType, terminalType, supportService, status);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTerminalQueryInfo {\n");
    
    sb.append("    terminalIds: ").append(toIndentedString(terminalIds)).append("\n");
    sb.append("    companyInfo: ").append(toIndentedString(companyInfo)).append("\n");
    sb.append("    terminalNo: ").append(toIndentedString(terminalNo)).append("\n");
    sb.append("    terminalName: ").append(toIndentedString(terminalName)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    terminalType: ").append(toIndentedString(terminalType)).append("\n");
    sb.append("    supportService: ").append(toIndentedString(supportService)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
