package com.xforceplus.seller.config.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
@ApiModel("查询库存请求")
public class QueryInventoryRequest {
    @ApiModelProperty("税号集合,必填")
    private List<String> taxNoList;
    @ApiModelProperty("发票类型集合")
    private List<String> invoiceTypeList;
    @ApiModelProperty("设备编号集合")
    private List<String> deviceNoList;
    @ApiModelProperty("终端编号")
    private String terminalNo;
    @ApiModelProperty("设备类型,必填")
    private String deviceType;
    @ApiModelProperty("设备唯一码，优先处理deviceNoList")
    private List<String> deviceUnList;
}
