package com.xforceplus.seller.config.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@ApiModel("查询手工创建了抬头和票面人规则")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class QueryManualInitConfigRequest {
  @ApiModelProperty("销方公司税号")
  private String sellerTaxNo;

  /**
   * 优先使用 settledInfoList 参数， 如果没传 使用 salesbillTypeList， 都未传递报错
   */
  @ApiModelProperty("业务单类型集合")
  private List<String> salesbillTypeList;
  @ApiModelProperty("入驻信息集合")
  private List<SettledInfo> settledInfoList;

  @Data
  @AllArgsConstructor
  @NoArgsConstructor
  public static class SettledInfo {
    @ApiModelProperty("渠道租户Id")
    private Long channelTenantId;
    @ApiModelProperty("渠道产品代码")
    private String channelProductCode;
    @ApiModelProperty("入驻业务单类型")
    private String salesbillType;
  }

}
