package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@ApiModel("备注限制")
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class RemarkLimitData implements Serializable {
    @ApiModelProperty("发票类型")
    private String invoiceType;
    @ApiModelProperty("开票类型")
    private String issueType;
    @ApiModelProperty("设备类型")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Integer deviceType;
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Integer remarkLength;

}
