package com.xforceplus.seller.config.client.model;

import com.xforceplus.seller.config.client.constant.ValueEnum;
import lombok.*;
import org.apache.commons.lang3.EnumUtils;

import java.io.Serializable;
import java.util.Optional;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class SettledSalesbillTypeInfoVo implements Serializable {
    private String salesbillType;
    private String sellerTaxNo;
    private Boolean isSettled;
    private Integer initedConfig;

    @RequiredArgsConstructor
    public enum InitedConfigEnum implements ValueEnum<Integer> {
        UN_INIT_CONFIG(0, "未配置"),
        INIT_CONFIG(1, "已配置"),
        NOT_NEED_INIT_CONFIG(2, "无需配置");

        @Getter
        public final Integer value;

        @Getter
        public final String desc;
        public static Optional<InitedConfigEnum> getEnumByValue(Integer value) {
            return value == null ? Optional.empty()
                    : EnumUtils.getEnumList(InitedConfigEnum.class).stream().filter(r -> value.equals(r.getValue())).findFirst();
        }

    }

}
