package com.xforceplus.seller.config.client.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@Data
public class SettledTemplateConifgVo implements Serializable {

    private List<CfgTemplateObjVo> cfgTemplateObjVoList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class CfgTemplateObjVo  implements Serializable {
        private Long templateObjId;
        private String templateObjCode;
        private String templateObjName;
        private String templateObjDesc;
        private String templateObjType;
        private String industryCode;
        private Date createTime;
        private Long createUser;
        private Date updateTime;
        private Long updateUser;
        private String invoiceType;
        private String taxInvoiceSource;
        List<SettledTemplateConifgVo.CfgTemplateObjMetadataVo> cfgTemplateObjMetadataList;

        public static void convert(CfgTemplateObjVo cfgTemplateObjVo) {
            if (StringUtils.isBlank(cfgTemplateObjVo.getTemplateObjCode())) {
                return;
            }
            List<String> templateObjCodeList = Arrays.asList(cfgTemplateObjVo.getTemplateObjCode().split("-"));
            cfgTemplateObjVo.setInvoiceType(templateObjCodeList.size() > 2 ? templateObjCodeList.get(2) : "");
            cfgTemplateObjVo.setTaxInvoiceSource(templateObjCodeList.size() > 3 ? templateObjCodeList.get(3) : null);
            return;
        }
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class CfgTemplateObjMetadataVo implements Serializable {
        private Long businessObjMetadataId;
        private Long businessObjId;
        private String fieldName;
        private String fieldDisplayName;
        private String fieldGroup;
        private String fieldGroupName;
        private Integer fieldGroupIndex;
        private Integer fieldRequired;
        private String fieldType;
        private String fieldQueryType;
        private String fieldEnumValue;
        private String fieldDefaultValue;
        private Integer fieldLength;
        private Integer fieldSort;
        private Integer fieldGridRow;
        private Integer fieldGridColumn;
        private Integer fieldVisible;
        private Integer fieldReadonly;
        private String displayType;
        private String associativeUrl;
        private Integer virtual;
        private Integer fixed;
        private Integer fixedUpdate;
        private Date createTime;
        private Long createUser;
        private Date updateTime;
        private Long updateUser;
        private Integer commonUsed;

        private String templateObjCode;
        private String templateObjId;
    }

}
