package com.xforceplus.seller.config.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@ApiModel("门店信息")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class StoreData implements Serializable {
    @ApiModelProperty("组织类型")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Integer orgType;
    @ApiModelProperty("门店名称")
    private String storeName;
    @ApiModelProperty("组织id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long orgId;
    @ApiModelProperty("所属公司")
    private String companyName;
    @ApiModelProperty("公司税号")
    private String companyTaxNo;
    @ApiModelProperty("公司id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long companyId;
    @ApiModelProperty("组织代码，门店号")
    private String orgCode;
}
