package com.xforceplus.seller.config.client.parse.bean;
import com.xforceplus.seller.config.client.parse.BaseRuleBean;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 项目名称: 票易通
 * 模块名称: 发票匹配单据规则DTO 返回给其他应用或微服务
 * JDK 版本: JDK1.8
 * 说明:
 * 作者(@author): wangjingshuang
 * 创建时间: 2020年2月13日17:07:17
 */
@Data
@ToString
public class InvoiceMatchBillConfigDTO extends BaseRuleBean {
    @ApiModelProperty("自动匹配开关")
    private Boolean autoInvoiceMatchSwitch;
    @ApiModelProperty("自动匹配条件")
    private List<String> autoInvoiceMatchCondition  = new ArrayList<>();
    @ApiModelProperty("匹配容差")
    private BigDecimal allowanceNum;
    @ApiModelProperty("匹配可选字段")
    private List<String> invoiceMatchOptionalFieldList  = new ArrayList<>();
    @ApiModelProperty("匹配标准字段")
    private List<String> invoiceMatchStandardFieldList  = new ArrayList<>();
    @ApiModelProperty("匹配的发票来源")
    private List<String> invoiceOrigin  = new ArrayList<>();
    @ApiModelProperty("自动关联红蓝票")
    private Boolean autoRelationInvoice = true;
    @ApiModelProperty("忽略匹配纸电发票类型")
    private Boolean ignoreElectricInvoiceType = false;
}
