package com.xforceplus.seller.config.client.parse.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.FirstIssuerRuleDTO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;

/**
 * @Description 优先开票人解析器
 * @Date
 * @return
 **/
@Component
public class FirstIssuerParser implements ConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(FirstIssuerParser.class);

    @Override
    public FirstIssuerRuleDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {

        FirstIssuerRuleDTO firstIssuerRuleDTO = new FirstIssuerRuleDTO();
        for (MsConfigItemBean msConfigItemBean : cfgConfigItemEntities) {
            firstIssuerRuleDTO.setRuldId(msConfigItemBean.getConfigId());
            String fieldName = msConfigItemBean.getConfigItemName();
            List<String> itemValueList = msConfigItemBean.getConfigItemValue();
            if (CommonTools.isEmpty(fieldName)){
                continue;
            }

            //当配置项值 设置了错误的格式，取出的集合是空则给一个默认值
            if (CollectionUtils.isEmpty(itemValueList)) {
                logger.warn("InvoiceSplitParse--parse--系统配置项值设置错误:null");
                itemValueList = Lists.newArrayList("");
            }
            String itemValue = itemValueList.get(0);
            if ("firstIssuer".equals(fieldName)) {
                firstIssuerRuleDTO.setFirstIssuer(itemValue);
            }
            else if ("issueType".equals(fieldName)){
                firstIssuerRuleDTO.setIssueType(itemValue);
            }

            // 开票人不在线是否自动选择其他开票人
            else if (Objects.equals(fieldName, "autoSelectOtherOnlineIssuer")) {
                firstIssuerRuleDTO.setAutoSelectOtherOnlineIssuer(StringUtils.isBlank(itemValue) ? 1 : Integer.parseInt(itemValue));
            }
        }
        return firstIssuerRuleDTO;
    }
}
