package com.xforceplus.seller.config.client.parse.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.seller.config.client.model.MatchFieldInfo;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.InvoiceMatchBillConfigDTO;
import com.xforceplus.xplatframework.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

/**
 * 项目名称: 票易通
 * 模块名称: 发票匹配单据规则解析器
 * JDK 版本: JDK1.8
 * 说明:
 * 作者(@author): wangjingshuang
 * 创建时间: 2020年2月13日17:26:41
 */
@Component
@Slf4j
public class InvoiceMatchBillParser implements ConfigParser {

    @Override
    public InvoiceMatchBillConfigDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {
        InvoiceMatchBillConfigDTO invoiceMatchBillConfigDTO = new InvoiceMatchBillConfigDTO();
        for (MsConfigItemBean msConfigItemBean : cfgConfigItemEntities) {
            invoiceMatchBillConfigDTO.setRuldId(msConfigItemBean.getConfigId());
            String fieldName = msConfigItemBean.getConfigItemName();
            List<String>  itemValueList = msConfigItemBean.getConfigItemValue();

            //当配置项值 设置了错误的格式，取出的集合是空则给一个默认值
            if (CollectionUtils.isEmpty(itemValueList)) {
                log.info("configId:{}--InvoiceMatchBillParser--parse--发票匹配业务单配置项值设置错误:null", msConfigItemBean.getConfigId());
                itemValueList = Lists.newArrayList("");
            }
            String itemValue = itemValueList.get(0);
            if ("autoInvoiceMatchSwitch".equals(fieldName)) {
                invoiceMatchBillConfigDTO.setAutoInvoiceMatchSwitch(Boolean.parseBoolean(itemValue));
            }else if ("autoInvoiceMatchCondition".equals(fieldName)) {
                invoiceMatchBillConfigDTO.setAutoInvoiceMatchCondition(itemValueList);
            }else if ("allowanceNum".equals(fieldName)) {
                if (CommonTools.isEmpty(itemValue) || !Pattern.compile("^[0-9]\\d{0,13}(\\.\\d{0,4})?$").matcher(itemValue).matches()) {
                    log.error("发票匹配业务单配置项值容差只能为2位小数金额数据，传入值：{}", itemValue);
                    itemValue = String.valueOf(0);
                }
                invoiceMatchBillConfigDTO.setAllowanceNum(new BigDecimal(itemValue).setScale(2, BigDecimal.ROUND_HALF_UP));
            }else if ("invoiceMatchOptionalFieldList".equals(fieldName)) {
                invoiceMatchBillConfigDTO.setInvoiceMatchOptionalFieldList(itemValueList);
            }else if ("invoiceMatchStandardFieldList".equals(fieldName)) {
                List<String> fieldNameList = Lists.newArrayList();
                if (!CollectionUtils.isEmpty(itemValueList)) {
                    for (String fieldNameInfo : itemValueList) {
                        try {
                            MatchFieldInfo matchFieldInfo = JsonUtils.writeFastJsonToObject(fieldNameInfo, MatchFieldInfo.class);
                            if (Objects.isNull(matchFieldInfo) || Objects.isNull(matchFieldInfo.getField())) {
                                continue;
                            }
                            fieldNameList.add(matchFieldInfo.getField());
                        }catch (Exception e) {
                            e.printStackTrace();
                            log.error("InvoiceMatchBillConfigDTO fieldName {}", fieldNameInfo);
                        }
                    }
                }
                invoiceMatchBillConfigDTO.setInvoiceMatchStandardFieldList(fieldNameList);
            }else if("autoRelationInvoice".equals(fieldName)) {
                invoiceMatchBillConfigDTO.setAutoRelationInvoice(Boolean.parseBoolean(itemValue));
            }else if("ignoreElectricInvoiceType".equals(fieldName)) {
                invoiceMatchBillConfigDTO.setIgnoreElectricInvoiceType(Boolean.parseBoolean(itemValue));
            }else if("invoiceOrigin".equals(fieldName)) {
                invoiceMatchBillConfigDTO.setInvoiceOrigin(itemValueList);
            }
        }
        return invoiceMatchBillConfigDTO;
    }
}
