package com.xforceplus.seller.config.client.parse.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.RedConfirmMatchRuleDTO;
import com.xforceplus.xplatframework.utils.JsonUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 红字确认单匹配功能
 * @Author zzw
 * @Description
 * @Date
 * @return
 **/
@Component
public class RedConfirmParser implements ConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(RedConfirmParser.class);

    @Override
    public RedConfirmMatchRuleDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {
        if (CollectionUtils.isEmpty(cfgConfigItemEntities)) {
            return null;
        }
        RedConfirmMatchRuleDTO redConfirmMatchRuleDTO = new RedConfirmMatchRuleDTO();
        for (MsConfigItemBean msConfigItemBean : cfgConfigItemEntities) {
            redConfirmMatchRuleDTO.setRuldId(msConfigItemBean.getConfigId());
            String fieldName = msConfigItemBean.getConfigItemName();
            if (StringUtils.isEmpty(fieldName)) {
                continue;
            }
            List<String> itemValueList = msConfigItemBean.getConfigItemValue();
            if (CollectionUtils.isEmpty(itemValueList)) {
                logger.info("RedConfirmParser--itemValueList--parse--Merge配置项值设置错误:null");
                itemValueList = Lists.newArrayList("");
            }

            String value = itemValueList.get(0);
            if (!CommonTools.isEmpty(value)){
                if ("matchRule".equals(fieldName)) {
                    redConfirmMatchRuleDTO.setMatchRule(value);
                }
                // matchCalRule   matchDiff matchCondition
                else if ("matchCalRule".equals(fieldName)) {
                    redConfirmMatchRuleDTO.setMatchCalRule(itemValueList.get(0));
                } else if ("matchDiff".equals(fieldName)) {
                    redConfirmMatchRuleDTO.setMatchDiff(itemValueList.get(0));
                } else if ("matchItemDiff".equals(fieldName)) {
                    // 明细匹配容差
                    redConfirmMatchRuleDTO.setMatchItemDiff(itemValueList.get(0));
                } else if ("unitPriceDiff".equals(fieldName)) {
                    redConfirmMatchRuleDTO.setUnitPriceDiff(itemValueList.get(0));
                }
                if ("taxAmountDiff".equals(fieldName)) {
                    redConfirmMatchRuleDTO.setTaxAmountDiff(value);
                }
                if ("mainMatchStrategy".equals(fieldName)) {
                    try {
                        if (StringUtils.isBlank(value)) {
                            redConfirmMatchRuleDTO.setMainMatchStrategy(Lists.newArrayList());
                        } else {
                            redConfirmMatchRuleDTO.setMainMatchStrategy(JsonUtils.writeJsonToListObject(value, RedConfirmMatchRuleDTO.MainMatchCondition.class));
                        }
                    } catch (Exception e) {
                        logger.error("解析匹配策略字段异常:{}", e.getMessage(), e);
                        throw new RuntimeException("解析匹配策略字段异常");
                    }
                }
            }
            if ("matchCondition".equals(fieldName)) {
                if (CollectionUtils.isNotEmpty(msConfigItemBean.getConfigItemValue())){
                    redConfirmMatchRuleDTO.setMatchCondition(itemValueList);
                }
            }


        }

        return redConfirmMatchRuleDTO;
    }

}

