/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.client.parse.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.IssueValidateConfigDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class IssueValidateConfigParser
implements ConfigParser {
    @Override
    public IssueValidateConfigDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {
        IssueValidateConfigDTO issueValidateConfigDTO = new IssueValidateConfigDTO();
        for (MsConfigItemBean msConfigItemBean : cfgConfigItemEntities) {
            issueValidateConfigDTO.setRuldId(msConfigItemBean.getConfigId());
            String fieldName = msConfigItemBean.getConfigItemName();
            ArrayList itemValueList = msConfigItemBean.getConfigItemValue();
            if (CommonTools.isEmpty((String)fieldName)) continue;
            if (CollectionUtils.isEmpty(itemValueList)) {
                itemValueList = Lists.newArrayList((Object[])new String[]{""});
            }
            String itemValue = itemValueList.get(0);
            if ("limitAmount".equals(fieldName)) {
                issueValidateConfigDTO.setLimitAmount(new BigDecimal(itemValue));
                continue;
            }
            if (!"limitMessageTemplate".equals(fieldName)) continue;
            issueValidateConfigDTO.setLimitMessageTemplate(itemValue);
        }
        return issueValidateConfigDTO;
    }
}

