/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.client.parse.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.seller.config.client.constant.ValueEnum;
import com.xforceplus.seller.config.client.constant.smartmatch.SmartMatchAmountCheckRule;
import com.xforceplus.seller.config.client.constant.smartmatch.SmartMatchFieldUseKind;
import com.xforceplus.seller.config.client.constant.smartmatch.SmartMatchFindAlgorithm;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.parse.ConfigParser;
import com.xforceplus.seller.config.client.parse.bean.SmartMatchRuleDTO;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SmartMatchRuleParser
implements ConfigParser {
    private static final Logger log = LoggerFactory.getLogger(SmartMatchRuleParser.class);

    @Override
    public SmartMatchRuleDTO parse(List<MsConfigItemBean> cfgConfigItemEntities) {
        if (CollectionUtils.isEmpty(cfgConfigItemEntities)) {
            return null;
        }
        SmartMatchRuleDTO smartMatchRuleDTO = new SmartMatchRuleDTO();
        for (MsConfigItemBean msConfigItemBean : cfgConfigItemEntities) {
            String value;
            smartMatchRuleDTO.setRuldId(msConfigItemBean.getConfigId());
            String fieldName = msConfigItemBean.getConfigItemName();
            if (StringUtils.isEmpty((CharSequence)fieldName)) continue;
            ArrayList itemValueList = msConfigItemBean.getConfigItemValue();
            if (CollectionUtils.isEmpty(itemValueList)) {
                log.info("RedConfirmParser--itemValueList--parse--Merge\u914d\u7f6e\u9879\u503c\u8bbe\u7f6e\u9519\u8bef:null");
                itemValueList = Lists.newArrayList((Object[])new String[]{""});
            }
            if (CommonTools.isEmpty((String)(value = itemValueList.get(0)))) continue;
            switch (fieldName) {
                case "matchCondition": {
                    Map<SmartMatchFieldUseKind, List<SmartMatchRuleDTO.SmartMatchCondition>> smartMatchConditionMap;
                    try {
                        List smartMatchConditions = JsonUtils.writeJsonToListObject((String)value, SmartMatchRuleDTO.SmartMatchCondition.class);
                        smartMatchConditionMap = smartMatchConditions.stream().collect(Collectors.groupingBy(r -> r.getField().getUseKind()));
                    }
                    catch (Exception e) {
                        log.error("\u89e3\u6790\u5339\u914d\u7b56\u7565\u5b57\u6bb5\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
                        throw new RuntimeException("\u89e3\u6790\u6253\u5206\u89c4\u5219\u5b57\u6bb5\u5f02\u5e38");
                    }
                    smartMatchRuleDTO.setFindRule(smartMatchConditionMap.getOrDefault(SmartMatchFieldUseKind.FILTER, Lists.newArrayList()).stream().map(this::convertFindRuleItem).collect(Collectors.toList()));
                    smartMatchRuleDTO.setCalScoreRule(smartMatchConditionMap.getOrDefault(SmartMatchFieldUseKind.SCORE, Lists.newArrayList()).stream().map(this::convertCalScoreRuleItem).collect(Collectors.toList()));
                    break;
                }
                case "redReason": {
                    smartMatchRuleDTO.setRedReason(value);
                    break;
                }
                case "matchAlgorithm": {
                    smartMatchRuleDTO.setMatchAlgorithm(Integer.parseInt(value));
                    break;
                }
                case "amountCheckRule": {
                    smartMatchRuleDTO.setAmountCheckRule(StringUtils.isBlank((CharSequence)value) ? SmartMatchAmountCheckRule.PRICING_AMOUNT_SAME.getValue() : ValueEnum.getEnumByValue(SmartMatchAmountCheckRule.class, Integer.parseInt(value)).orElse(SmartMatchAmountCheckRule.PRICING_AMOUNT_SAME).getValue());
                    break;
                }
                case "taxAmountMaxAdjust": {
                    smartMatchRuleDTO.setTaxAmountMaxAdjust(StringUtils.isBlank((CharSequence)value) ? BigDecimal.ZERO : new BigDecimal(value));
                    break;
                }
                case "findAlgorithm": {
                    smartMatchRuleDTO.setFindAlgorithm(StringUtils.isBlank((CharSequence)value) ? SmartMatchFindAlgorithm.ITEM_NUM_LEAST.getValue() : ValueEnum.getEnumByValue(SmartMatchFindAlgorithm.class, Integer.parseInt(value)).orElse(SmartMatchFindAlgorithm.ITEM_NUM_LEAST).getValue());
                    break;
                }
            }
        }
        return smartMatchRuleDTO;
    }

    private SmartMatchRuleDTO.FindRuleItem convertFindRuleItem(SmartMatchRuleDTO.SmartMatchCondition smartMatchCondition) {
        SmartMatchRuleDTO.FindRuleItem findRuleItem = new SmartMatchRuleDTO.FindRuleItem();
        findRuleItem.setField(smartMatchCondition.getField());
        findRuleItem.setOp(smartMatchCondition.getOp());
        findRuleItem.setType(smartMatchCondition.getType());
        findRuleItem.setValue(smartMatchCondition.getValue());
        findRuleItem.setValueList(smartMatchCondition.getValueList());
        findRuleItem.setTimeMode(smartMatchCondition.getTimeMode());
        findRuleItem.setFieldKind(smartMatchCondition.getField().getKind().getValue());
        return findRuleItem;
    }

    private SmartMatchRuleDTO.CalScoreRuleItem convertCalScoreRuleItem(SmartMatchRuleDTO.SmartMatchCondition smartMatchCondition) {
        SmartMatchRuleDTO.CalScoreRuleItem calScoreRuleItem = new SmartMatchRuleDTO.CalScoreRuleItem();
        calScoreRuleItem.setField(smartMatchCondition.getField());
        calScoreRuleItem.setType(smartMatchCondition.getType());
        calScoreRuleItem.setMatchType(smartMatchCondition.getOp().name());
        calScoreRuleItem.setTolerance(smartMatchCondition.getTolerance());
        calScoreRuleItem.setForce(smartMatchCondition.getForce());
        calScoreRuleItem.setValueMode(smartMatchCondition.getValueMode());
        calScoreRuleItem.setValue(smartMatchCondition.getValue());
        return calScoreRuleItem;
    }
}

