/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.bizconfig.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.bss.external.client.model.CompanyModel;
import com.xforceplus.bss.external.client.model.GetGroupInfoRequest;
import com.xforceplus.bss.external.client.model.GetGroupInfoResponse;
import com.xforceplus.bss.external.client.model.GroupModel;
import com.xforceplus.bss.external.client.model.SearchCompanyListRequest;
import com.xforceplus.bss.external.client.model.SearchCompanyListResponse;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.bizconfig.service.ConfigBizConfigService;
import com.xforceplus.seller.config.client.CompanyApiClient;
import com.xforceplus.seller.config.client.GroupApiClient;
import com.xforceplus.seller.config.client.constant.BusinessSalesBillTypeEnum;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.constant.SalesListPrintEnum;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.matchparser.impl.ConfigMatchParserImpl;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigItemAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.model.MsConfigItemQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigItemTempBean;
import com.xforceplus.seller.config.client.model.MsConfigPageDTO;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.client.model.MsEnumBean;
import com.xforceplus.seller.config.client.model.MsMataDataQueryRequest;
import com.xforceplus.seller.config.client.model.MsTmpConfigAddRequest;
import com.xforceplus.seller.config.client.parse.bean.InvoiceSplitrRuleDTO;
import com.xforceplus.seller.config.client.parse.impl.InvoiceSplitParser;
import com.xforceplus.seller.config.common.ConfigErrorEnum;
import com.xforceplus.seller.config.constants.BusinessBillType;
import com.xforceplus.seller.config.exception.CompanyQueryException;
import com.xforceplus.seller.config.exception.ConfigCreateException;
import com.xforceplus.seller.config.exception.ConfigExsitException;
import com.xforceplus.seller.config.exception.ConfigItemRequiredException;
import com.xforceplus.seller.config.exception.ConfigNameRepeatException;
import com.xforceplus.seller.config.exception.InvoiceFaceConfigRepeatException;
import com.xforceplus.seller.config.exception.InvoiceSplitConfigException;
import com.xforceplus.seller.config.exception.ThridPartyInvokeException;
import com.xforceplus.seller.config.metadata.service.ConfigMetaDataService;
import com.xforceplus.seller.config.repository.dao.CfgConfigDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigItemDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigItemTempDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigTempDao;
import com.xforceplus.seller.config.repository.dao.CfgTemplateObjDao;
import com.xforceplus.seller.config.repository.dao.CfgTemplateObjMetadataDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigExtDao;
import com.xforceplus.seller.config.repository.daoext.ConfigItemExtDao;
import com.xforceplus.seller.config.repository.model.CfgConfigEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigExample;
import com.xforceplus.seller.config.repository.model.CfgConfigItemEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigItemExample;
import com.xforceplus.seller.config.repository.model.CfgConfigItemTempEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigItemTempExample;
import com.xforceplus.seller.config.repository.model.CfgConfigTempEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigTempExample;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjEntity;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjExample;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjMetadataExample;
import com.xforceplus.seller.config.repository.model.modelext.CfgConfigExtExample;
import com.xforceplus.seller.config.system.enums.InvoiceType;
import com.xforceplus.seller.config.translater.ConfigEntityTranslater;
import com.xforceplus.seller.config.translater.ConfigItemEntityTranslator;
import com.xforceplus.seller.config.translater.ExamapleTranslater;
import com.xforceplus.seller.config.util.CommonTools;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ConfigBizConfigService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigBizConfigService.class);
    private CfgConfigDao cfgConfigDao;
    private CfgConfigItemDao cfgConfigItemDao;
    private CfgConfigTempDao cfgConfigTempDao;
    private CfgConfigItemTempDao cfgConfigItemTempDao;
    private IDGenerator generator;
    private CompanyApiClient companyApiClient;
    private GroupApiClient groupApiClient;
    private CfgTemplateObjDao cfgTemplateObjDao;
    private CfgTemplateObjMetadataDao cfgTemplateObjMetadataDao;
    private ConfigItemExtDao configItemExtDao;
    private CfgConfigExtDao cfgConfigExtDao;
    private ConfigMetaDataService configMetaDataService;
    private ConfigMatchParserImpl configMatchParserImpl;

    @Autowired
    public ConfigBizConfigService(CfgConfigDao cfgConfigDao, CfgConfigItemDao cfgConfigItemDao, CfgConfigTempDao cfgConfigTempDao, CfgConfigItemTempDao cfgConfigItemTempDao, IDGenerator generator, CompanyApiClient companyApiClient, GroupApiClient groupApiClient, CfgTemplateObjDao cfgTemplateObjDao, CfgTemplateObjMetadataDao cfgTemplateObjMetadataDao, ConfigItemExtDao configItemExtDao, CfgConfigExtDao cfgConfigExtDao, ConfigMetaDataService configMetaDataService, ConfigMatchParserImpl configMatchParserImpl) {
        this.cfgConfigDao = cfgConfigDao;
        this.cfgConfigItemDao = cfgConfigItemDao;
        this.cfgConfigTempDao = cfgConfigTempDao;
        this.cfgConfigItemTempDao = cfgConfigItemTempDao;
        this.generator = generator;
        this.companyApiClient = companyApiClient;
        this.groupApiClient = groupApiClient;
        this.cfgTemplateObjDao = cfgTemplateObjDao;
        this.cfgTemplateObjMetadataDao = cfgTemplateObjMetadataDao;
        this.configItemExtDao = configItemExtDao;
        this.cfgConfigExtDao = cfgConfigExtDao;
        this.configMetaDataService = configMetaDataService;
        this.configMatchParserImpl = configMatchParserImpl;
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteCfgConfig(List<Long> configIdList, Long userId) {
        if (CollectionUtils.isEmpty(configIdList)) {
            return 1;
        }
        configIdList = configIdList.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        CfgConfigExtExample cfgConfigExtExample = new CfgConfigExtExample();
        cfgConfigExtExample.setConfigIdList(configIdList);
        cfgConfigExtExample.setPreStatus(StatusEnum.NORMAL.getStatus());
        cfgConfigExtExample.setAfterStatus(StatusEnum.DELETE.getStatus());
        cfgConfigExtExample.setCreateUser(userId);
        cfgConfigExtExample.setUpdateTime(new Timestamp(System.currentTimeMillis()));
        int affected = this.cfgConfigExtDao.deleteCfgConfigEntityByIds(cfgConfigExtExample);
        if (affected != configIdList.size()) {
            throw new RuntimeException("\u5220\u9664\u89c4\u5219\u5931\u8d25.");
        }
        return 1;
    }

    @Transactional(rollbackFor={Exception.class})
    public Response addCfgConfig(MsConfigAddRequestWithUserInfo msConfigAddRequestWithUserInfo) {
        boolean ruleExists;
        logger.info("addCfgConfigAndItem msConfigAddRequestWithUserInfo===>{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigAddRequestWithUserInfo));
        Response response = Response.failed((String)"");
        List msConfigBeanList = msConfigAddRequestWithUserInfo.getItemDTOList();
        if (CollectionUtils.isEmpty((Collection)msConfigBeanList)) {
            response.setMessage("\u89c4\u5219\u914d\u7f6e\u9879\u4e0d\u80fd\u4e3a\u7a7a.");
            return response;
        }
        MsConfigBean msConfigBean = (MsConfigBean)msConfigBeanList.get(0);
        String busniessBillType = msConfigBean.getBusinessBillType();
        if (!BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(busniessBillType) && !BusinessSalesBillTypeEnum.AP.getBusinessSalesBillType().equals(busniessBillType)) {
            response.setMessage(ConfigErrorEnum.CONFIG_META_DATA_CHECK_ERROR.message());
            return response;
        }
        MsCommonUserInfo userInfo = msConfigAddRequestWithUserInfo.getUserInfo();
        if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(msConfigBean.getBusinessBillType())) {
            msConfigBean.setSellerGroupId(userInfo.getGroupId());
        } else {
            msConfigBean.setPurchaserGroupId(userInfo.getGroupId());
        }
        this.fillCompanyInfo(msConfigBean);
        logger.info("addCfgConfigAndItem msConfigBean2==========>{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigBean));
        logger.info("msConfigBean.getConfigId()==========>{}", (Object)msConfigBean.getConfigId());
        if ((null == msConfigBean.getConfigId() || msConfigBean.getConfigId() == 0L) && (ruleExists = this.queryInvoiceConfigRuleExists(msConfigBean))) {
            response.setMessage("\u89c4\u5219\u5df2\u5b58\u5728.");
            return response;
        }
        this.checkBusinessConfig(msConfigBean);
        this.checkConfigItemRequired(msConfigBean);
        Long configId = this.addOrUpdateCfgConfig(msConfigBean, userInfo);
        List msConfigItemBeans = msConfigBean.getItemList();
        if (configId.equals(msConfigBean.getConfigId())) {
            this.configItemExtDao.deleteConfigItemByConfigId(configId);
        }
        if (!CollectionUtils.isEmpty((Collection)msConfigItemBeans)) {
            MsConfigItemAddRequestWithUserInfo msConfigItemAddRequest = new MsConfigItemAddRequestWithUserInfo();
            msConfigItemAddRequest.setItemDTOList(msConfigItemBeans);
            msConfigItemAddRequest.setConfigId(configId);
            msConfigItemAddRequest.setUserInfo(userInfo);
            this.addCfgConfigItem(msConfigItemAddRequest, msConfigBean);
        }
        response.setCode(Response.OK);
        response.setMessage("\u6dfb\u52a0\u6210\u529f.");
        return response;
    }

    private Long addOrUpdateCfgConfig(MsConfigBean msConfigBean, MsCommonUserInfo userInfo) {
        Long configId = msConfigBean.getConfigId();
        CfgConfigEntity entity = ConfigEntityTranslater.convertFromMsConfigBean((MsConfigBean)msConfigBean);
        entity.setUpdateTime(new Date());
        if (configId == null || configId == 0L) {
            int result;
            this.checkConfigName(msConfigBean, userInfo.getGroupId());
            configId = this.generator.nextId();
            entity.setConfigId(configId);
            entity.setStatus(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
            entity.setCreateTime(entity.getUpdateTime());
            entity.setCreateUser(userInfo.getUserId());
            try {
                result = this.cfgConfigDao.insertSelective(entity);
            }
            catch (DuplicateKeyException excption) {
                throw new ConfigExsitException();
            }
            if (result < 1) {
                throw new ConfigCreateException();
            }
            return configId;
        }
        try {
            this.cfgConfigDao.updateByPrimaryKeySelective(entity);
        }
        catch (DuplicateKeyException excption) {
            throw new ConfigExsitException();
        }
        return entity.getConfigId();
    }

    @Transactional(rollbackFor={Exception.class})
    public int addCfgConfigItem(MsConfigItemAddRequestWithUserInfo msConfigItemAddRequest, MsConfigBean temp) {
        List msConfigItemBeans = msConfigItemAddRequest.getItemDTOList();
        if (ConfigTypeEnum.BILL_MERGE_TYPE.getConfigType().intValue() == temp.getConfigType().intValue()) {
            CfgTemplateObjExample cfgTemplateObjExample = new CfgTemplateObjExample();
            cfgTemplateObjExample.createCriteria().andTemplateObjCodeEqualTo(ConfigTypeEnum.BILL_MERGE_TYPE.getObjCode());
            CfgTemplateObjEntity cfgTemplateObjEntity = this.cfgTemplateObjDao.selectOneByExample(cfgTemplateObjExample);
            if (cfgTemplateObjEntity != null) {
                CfgTemplateObjMetadataExample cfgTemplateObjMetadataExample = new CfgTemplateObjMetadataExample();
                ArrayList<String> fieldNames = new ArrayList<String>(2);
                fieldNames.add("defaultAssociationCondition");
                fieldNames.add("defaultMergerCondition");
                cfgTemplateObjMetadataExample.createCriteria().andBusinessObjIdEqualTo(cfgTemplateObjEntity.getTemplateObjId()).andFieldNameIn(fieldNames);
                List list = this.cfgTemplateObjMetadataDao.selectByExample(cfgTemplateObjMetadataExample);
                list.forEach(m -> {
                    MsConfigItemBean msConfigItemBean = new MsConfigItemBean();
                    msConfigItemBean.setConfigItemName(m.getFieldName());
                    msConfigItemBean.setConfigItemDisplayName(m.getFieldDisplayName());
                    String fieldEnumValue = m.getFieldEnumValue();
                    ArrayList defaultValues = new ArrayList();
                    List msEnumBeans = JsonUtils.writeJsonToListObject((String)fieldEnumValue, MsEnumBean.class);
                    msEnumBeans.forEach(item -> defaultValues.add(item.getValue()));
                    msConfigItemBean.setConfigItemValue(defaultValues);
                    msConfigItemBeans.add(msConfigItemBean);
                });
            }
        }
        Long configId = msConfigItemAddRequest.getConfigId();
        MsCommonUserInfo userInfo = msConfigItemAddRequest.getUserInfo();
        for (MsConfigItemBean configItemBean : msConfigItemBeans) {
            int result;
            String value;
            List list;
            Long id = configItemBean.getConfigItemId();
            if (configId == null || configId == 0L) {
                return 0;
            }
            if ("invoiceLimit".equals(configItemBean.getConfigItemName()) && temp != null && !CollectionUtils.isEmpty((Collection)(list = configItemBean.getConfigItemValue())) && !CommonTools.isEmpty((String)(value = (String)list.get(0)))) {
                this.checkLimitAmt(temp, value);
            }
            CfgConfigItemEntity cfgConfigItemEntity = ConfigItemEntityTranslator.convertFromMsConfigItemBean((MsConfigItemBean)configItemBean);
            cfgConfigItemEntity.setUpdateUser(userInfo.getUserId());
            cfgConfigItemEntity.setUpdateTime(new Date());
            if (id == null || id == 0L) {
                id = this.generator.nextId();
                cfgConfigItemEntity.setConfigItemId(id);
                cfgConfigItemEntity.setConfigId(configId);
                cfgConfigItemEntity.setCreateTime(cfgConfigItemEntity.getUpdateTime());
                cfgConfigItemEntity.setCreateUser(cfgConfigItemEntity.getUpdateUser());
                result = this.cfgConfigItemDao.insertSelective(cfgConfigItemEntity);
            } else {
                result = this.cfgConfigItemDao.updateByPrimaryKeySelective(cfgConfigItemEntity);
            }
            if (result >= 1) continue;
            throw new ConfigCreateException();
        }
        return 1;
    }

    public MsConfigPageDTO queryEffectiveConfig(MsConfigQueryRequest msConfigQueryRequest) {
        return null;
    }

    public Response getOptimalMatchConfig(MsConfigQueryRequest msConfigQueryRequest) {
        List settingCfgConfigEntityList = this.querySettingConfigList(msConfigQueryRequest);
        logger.info("getOptimalMatchConfig---cfgConfigEntityList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)settingCfgConfigEntityList));
        if (CollectionUtils.isEmpty((Collection)settingCfgConfigEntityList)) {
            CfgConfigEntity defaultCfgConfigEntity = this.queryDefaultConfig(msConfigQueryRequest);
            MsConfigBean defaultMsConfigBean = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)defaultCfgConfigEntity);
            logger.info("getOptimalMatchConfig---defaultMsConfigBean:{}", (Object)JsonUtils.writeObjectToFastJson((Object)defaultMsConfigBean));
            return this.fillConfigItemList2ConfigBean(defaultMsConfigBean);
        }
        MsConfigBean msConfigBean = ConfigEntityTranslater.convertFromMsConfigQueryRequest((MsConfigQueryRequest)msConfigQueryRequest);
        List settingMsConfigBeanList = settingCfgConfigEntityList.stream().map(item -> ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)item)).collect(Collectors.toList());
        MsConfigBean bestMsConfigBean = this.configMatchParserImpl.getBestMatchConfig(settingMsConfigBeanList, msConfigBean);
        logger.info("getOptimalMatchConfig---bestMsConfigBean:{}", (Object)JsonUtils.writeObjectToFastJson((Object)bestMsConfigBean));
        if (null == bestMsConfigBean) {
            CfgConfigEntity defaultCfgConfigEntity = this.queryDefaultConfig(msConfigQueryRequest);
            MsConfigBean defaultMsConfigBean = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)defaultCfgConfigEntity);
            logger.info("getOptimalMatchConfig---match--failed--defaultMsConfigBean:{}", (Object)JsonUtils.writeObjectToFastJson((Object)defaultMsConfigBean));
            return this.fillConfigItemList2ConfigBean(defaultMsConfigBean);
        }
        return this.fillConfigItemList2ConfigBean(bestMsConfigBean);
    }

    private Response fillConfigItemList2ConfigBean(MsConfigBean msConfigBean) {
        Response response = new Response();
        if (null != msConfigBean) {
            MsConfigItemQueryRequest request = new MsConfigItemQueryRequest();
            request.setConfigId(String.valueOf(msConfigBean.getConfigId()));
            List configItemList = this.queryConfigItemList(request);
            logger.info("getOptimalMatchConfig--itemList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)configItemList));
            response.setCode(Response.OK);
            response.setResult((Object)JsonUtils.writeObjectToFastJson((Object)configItemList));
        } else {
            response.setCode(Response.Fail);
        }
        return response;
    }

    private List<CfgConfigEntity> querySettingConfigList(MsConfigQueryRequest msConfigQueryRequest) {
        List cfgConfigEntityList;
        logger.info("querySettingConfigList----msConfigQueryRequest:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigQueryRequest));
        switch (1.$SwitchMap$com$xforceplus$seller$config$client$constant$ConfigTypeEnum[ConfigTypeEnum.of((Integer)msConfigQueryRequest.getConfigType()).ordinal()]) {
            case 1: {
                cfgConfigEntityList = this.querySettingSplitConfigByAROrAP(msConfigQueryRequest);
                break;
            }
            case 2: {
                cfgConfigEntityList = this.querySettingGroupMergeConfigByAROrAP(msConfigQueryRequest);
                break;
            }
            case 3: {
                cfgConfigEntityList = this.querySettingGroupMergeConfigByAROrAP(msConfigQueryRequest);
                break;
            }
            case 4: 
            case 5: {
                cfgConfigEntityList = this.querySettingInvoiceConfig(msConfigQueryRequest);
                break;
            }
            default: {
                cfgConfigEntityList = this.querySettingConfig(msConfigQueryRequest);
            }
        }
        return cfgConfigEntityList;
    }

    private CfgConfigEntity queryDefaultConfig(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigEntity cfgConfigEntity;
        switch (1.$SwitchMap$com$xforceplus$seller$config$client$constant$ConfigTypeEnum[ConfigTypeEnum.of((Integer)msConfigQueryRequest.getConfigType()).ordinal()]) {
            case 1: {
                cfgConfigEntity = this.queryDefaultSplitConfig((String)msConfigQueryRequest.getInvoiceType().get(0));
                break;
            }
            case 4: 
            case 5: {
                cfgConfigEntity = this.queryDefaultInvoiceConfig(msConfigQueryRequest.getBusinessBillType());
                break;
            }
            default: {
                cfgConfigEntity = this.queryDefaultConfig(msConfigQueryRequest.getConfigType());
            }
        }
        return cfgConfigEntity;
    }

    private CfgConfigEntity queryDefaultConfig(Integer configType) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = cfgConfigExample.createCriteria();
        criteria.andSellerGroupIdEqualTo(Long.valueOf(0L));
        criteria.andPurchaserGroupIdEqualTo(Long.valueOf(0L));
        criteria.andConfigTypeEqualTo(Byte.valueOf(configType.byteValue()));
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        return this.cfgConfigDao.selectOneByExample(cfgConfigExample);
    }

    private CfgConfigEntity queryDefaultSplitConfig(String invoiceType) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = cfgConfigExample.createCriteria();
        criteria.andSellerGroupIdEqualTo(Long.valueOf(0L));
        criteria.andPurchaserGroupIdEqualTo(Long.valueOf(0L));
        criteria.andConfigTypeEqualTo(Byte.valueOf(ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType().byteValue()));
        criteria.andInvoiceTypeEqualTo(invoiceType);
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        return this.cfgConfigDao.selectOneByExample(cfgConfigExample);
    }

    private CfgConfigEntity queryDefaultInvoiceConfig(String businessBillType) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = cfgConfigExample.createCriteria();
        criteria.andSellerGroupIdEqualTo(Long.valueOf(0L));
        criteria.andPurchaserGroupIdEqualTo(Long.valueOf(0L));
        criteria.andConfigTypeEqualTo(Byte.valueOf(ConfigTypeEnum.INVOICE_CONFIG_TYPE.getConfigType().byteValue()));
        criteria.andBusinessBillTypeEqualTo(businessBillType);
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        return this.cfgConfigDao.selectOneByExample(cfgConfigExample);
    }

    private List<CfgConfigEntity> querySettingSplitConfigByAROrAP(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        if (msConfigQueryRequest.getSellerGroupId() != null) {
            CfgConfigExample.Criteria criteriaAR = cfgConfigExample.createCriteria();
            criteriaAR.andSellerGroupIdEqualTo(msConfigQueryRequest.getSellerGroupId());
            criteriaAR.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
            criteriaAR.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
            criteriaAR.andSalesbillTypeIn((List)Lists.newArrayList((Object[])new String[]{"", msConfigQueryRequest.getSalesbillType()}));
            criteriaAR.andInvoiceTypeEqualTo((String)msConfigQueryRequest.getInvoiceType().get(0));
        }
        CfgConfigExample.Criteria criteriaAP = cfgConfigExample.createCriteria();
        if (msConfigQueryRequest.getPurchaserGroupId() != null) {
            criteriaAP.andPurchaserGroupIdEqualTo(msConfigQueryRequest.getPurchaserGroupId());
            criteriaAP.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
            criteriaAP.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
            criteriaAP.andSalesbillTypeIn((List)Lists.newArrayList((Object[])new String[]{"", msConfigQueryRequest.getSalesbillType()}));
            criteriaAP.andInvoiceTypeEqualTo((String)msConfigQueryRequest.getInvoiceType().get(0));
            if (msConfigQueryRequest.getSellerGroupId() != null) {
                cfgConfigExample.or(criteriaAP);
            }
        }
        return this.cfgConfigDao.selectByExample(cfgConfigExample);
    }

    private List<CfgConfigEntity> querySettingGroupMergeConfigByAROrAP(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigExample groupMergeExample = new CfgConfigExample();
        if (msConfigQueryRequest.getSellerGroupId() != null) {
            CfgConfigExample.Criteria groupCriteriaAR = groupMergeExample.createCriteria();
            groupCriteriaAR.andSellerGroupIdEqualTo(msConfigQueryRequest.getSellerGroupId());
            groupCriteriaAR.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
            groupCriteriaAR.andStatusEqualTo(Byte.valueOf(msConfigQueryRequest.getStatus().byteValue()));
        }
        if (msConfigQueryRequest.getPurchaserGroupId() != null) {
            CfgConfigExample.Criteria groupCriteriaAP = groupMergeExample.createCriteria();
            groupCriteriaAP.andPurchaserGroupIdEqualTo(msConfigQueryRequest.getPurchaserGroupId());
            groupCriteriaAP.andStatusEqualTo(Byte.valueOf(msConfigQueryRequest.getStatus().byteValue()));
            groupCriteriaAP.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
            if (msConfigQueryRequest.getSellerGroupId() != null) {
                groupMergeExample.or(groupCriteriaAP);
            }
        }
        return this.cfgConfigDao.selectByExample(groupMergeExample);
    }

    private List<CfgConfigEntity> querySettingInvoiceConfig(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria invoiceCriteria = cfgConfigExample.createCriteria();
        if (BusinessBillType.AR.value().equals(msConfigQueryRequest.getBusinessBillType())) {
            invoiceCriteria.andSellerGroupIdEqualTo(msConfigQueryRequest.getSellerGroupId());
            invoiceCriteria.andBusinessBillTypeEqualTo(msConfigQueryRequest.getBusinessBillType());
        } else {
            invoiceCriteria.andPurchaserGroupIdEqualTo(msConfigQueryRequest.getPurchaserGroupId());
            invoiceCriteria.andBusinessBillTypeEqualTo(msConfigQueryRequest.getBusinessBillType());
        }
        invoiceCriteria.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
        invoiceCriteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        invoiceCriteria.andSalesbillTypeIn((List)Lists.newArrayList((Object[])new String[]{"", msConfigQueryRequest.getSalesbillType()}));
        invoiceCriteria.andBusinessBillTypeEqualTo(msConfigQueryRequest.getBusinessBillType());
        return this.cfgConfigDao.selectByExample(cfgConfigExample);
    }

    private List<CfgConfigEntity> querySettingConfig(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigExample settingConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria settingCriteria = settingConfigExample.createCriteria();
        if (msConfigQueryRequest.getSellerGroupId() != null) {
            settingCriteria.andSellerGroupIdEqualTo(msConfigQueryRequest.getSellerGroupId());
        }
        if (msConfigQueryRequest.getPurchaserGroupId() != null && BusinessBillType.AP.value().equals(msConfigQueryRequest.getBusinessBillType())) {
            settingCriteria.andPurchaserGroupIdEqualTo(msConfigQueryRequest.getPurchaserGroupId());
        }
        if (msConfigQueryRequest.getSellerGroupId() == null || msConfigQueryRequest.getPurchaserGroupId() == null) {
            return new ArrayList<CfgConfigEntity>();
        }
        settingCriteria.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
        settingCriteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        settingCriteria.andSalesbillTypeIn((List)Lists.newArrayList((Object[])new String[]{"", msConfigQueryRequest.getSalesbillType()}));
        return this.cfgConfigDao.selectByExample(settingConfigExample);
    }

    public MsConfigPageDTO queryConfigList(MsConfigQueryRequest msConfigBean, Long groupId) {
        MsConfigPageDTO msConfigPageDTO = new MsConfigPageDTO();
        CfgConfigExample example = ExamapleTranslater.createConfigExampleByRequest((MsConfigQueryRequest)msConfigBean, (Long)groupId);
        example.setLimit(Integer.valueOf(msConfigBean.getPageSize() == null || msConfigBean.getPageSize() == 0 ? 10 : msConfigBean.getPageSize()));
        example.setOffset(this.getOffset(msConfigBean));
        List cfgConfigEntities = this.cfgConfigDao.selectByExample(example);
        Long count = this.cfgConfigDao.countByExample(example);
        msConfigPageDTO.setPageNo(msConfigBean.getPageNo());
        msConfigPageDTO.setTotal(Integer.valueOf(count.intValue()));
        ArrayList<MsConfigBean> result = new ArrayList<MsConfigBean>();
        for (CfgConfigEntity tmp : cfgConfigEntities) {
            MsConfigBean msConfigBeanTmp = ConfigEntityTranslater.convertFromConfigEntity((CfgConfigEntity)tmp);
            result.add(msConfigBeanTmp);
        }
        msConfigPageDTO.setItemDTOList(result);
        return msConfigPageDTO;
    }

    public Integer queryConfigCount(MsConfigQueryRequest msConfigBean, Long groupId) {
        CfgConfigExample example = ExamapleTranslater.createConfigExampleByRequest((MsConfigQueryRequest)msConfigBean, (Long)groupId);
        Long count = this.cfgConfigDao.countByExample(example);
        return count.intValue();
    }

    public List<MsConfigItemBean> queryConfigItemList(MsConfigItemQueryRequest cfgConfigItemRequest) {
        ArrayList<MsConfigItemBean> result;
        block3: {
            block2: {
                logger.info("queryConfigItemList===========cfgConfigItemRequest:{}", (Object)JsonUtils.writeObjectToFastJson((Object)cfgConfigItemRequest));
                CfgConfigItemExample cfgConfigItemExample = new CfgConfigItemExample();
                cfgConfigItemExample.createCriteria().andConfigIdEqualTo(Long.valueOf(cfgConfigItemRequest.getConfigId()));
                List cfgConfigItemEntityList = this.cfgConfigItemDao.selectByExample(cfgConfigItemExample);
                result = new ArrayList<MsConfigItemBean>();
                if (CollectionUtils.isEmpty((Collection)cfgConfigItemEntityList)) break block2;
                for (CfgConfigItemEntity cfgConfigItemEntity : cfgConfigItemEntityList) {
                    MsConfigItemBean msConfigItemBean = ConfigItemEntityTranslator.convertFromConfigItemEntity((CfgConfigItemEntity)cfgConfigItemEntity);
                    result.add(msConfigItemBean);
                }
                break block3;
            }
            CfgConfigItemTempExample cfgConfigTempExample = new CfgConfigItemTempExample();
            cfgConfigTempExample.createCriteria().andConfigIdEqualTo(Long.valueOf(cfgConfigItemRequest.getConfigId()));
            List cfgConfigItemTempEntities = this.cfgConfigItemTempDao.selectByExample(cfgConfigTempExample);
            if (CollectionUtils.isEmpty((Collection)cfgConfigItemTempEntities)) break block3;
            for (CfgConfigItemTempEntity cfgConfigItemEntity : cfgConfigItemTempEntities) {
                MsConfigItemBean msConfigItemBean = ConfigItemEntityTranslator.convertFromConfigItemTempEntity((CfgConfigItemTempEntity)cfgConfigItemEntity);
                result.add(msConfigItemBean);
            }
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long queryTempConfigItemList(MsTmpConfigAddRequest msTmpConfigQueryRequest) {
        List list = msTmpConfigQueryRequest.getEntityList();
        logger.info("cfg_config_temp md5 lists====={}", (Object)JsonUtils.writeObjectToFastJson((Object)list));
        String md5 = this.getMD5TempConfigItem(list);
        logger.info("cfg_config_temp md5======{}", (Object)md5);
        CfgConfigTempExample example = new CfgConfigTempExample();
        example.createCriteria().andMd5EqualTo(md5);
        List configTempEntityList = this.cfgConfigTempDao.selectByExample(example);
        logger.info("cfgConfigTempDao selectByExample ======{}", (Object)JsonUtils.writeObjectToFastJson((Object)configTempEntityList));
        if (CollectionUtils.isEmpty((Collection)configTempEntityList)) {
            this.checkTmpInvoiceInfo(list, msTmpConfigQueryRequest.getInvoiceType(), msTmpConfigQueryRequest.getSellerTaxNo(), msTmpConfigQueryRequest.getConfigType());
            CfgConfigTempEntity cfgConfigTempEntity = new CfgConfigTempEntity();
            Long id = this.generator.nextId();
            cfgConfigTempEntity.setConfigId(id);
            cfgConfigTempEntity.setMd5(md5);
            cfgConfigTempEntity.setUserId(msTmpConfigQueryRequest.getUserId());
            cfgConfigTempEntity.setCreateTime(new Date());
            cfgConfigTempEntity.setConfigName(UUID.randomUUID().toString());
            cfgConfigTempEntity.setUpdateTime(cfgConfigTempEntity.getCreateTime());
            this.cfgConfigTempDao.insert(cfgConfigTempEntity);
            for (MsConfigItemTempBean bean : list) {
                CfgConfigItemTempEntity cfgConfigItemTempEntity = ExamapleTranslater.tempBeanConvert2ItemTempEntity((MsConfigItemTempBean)bean, (Long)id);
                cfgConfigItemTempEntity.setCreateUser(msTmpConfigQueryRequest.getUserId());
                cfgConfigItemTempEntity.setCreateTime(new Date());
                cfgConfigItemTempEntity.setUpdateTime(cfgConfigItemTempEntity.getCreateTime());
                cfgConfigItemTempEntity.setUpdateUser(msTmpConfigQueryRequest.getUserId());
                cfgConfigItemTempEntity.setConfigItemId(Long.valueOf(this.generator.nextId()));
                this.cfgConfigItemTempDao.insert(cfgConfigItemTempEntity);
            }
            return id;
        }
        return ((CfgConfigTempEntity)configTempEntityList.get(0)).getConfigId();
    }

    private String getMD5TempConfigItem(List<MsConfigItemTempBean> msConfigItemTempBeanList) {
        HashMap configItemTempBeanMap = Maps.newHashMap();
        msConfigItemTempBeanList.forEach(tempBean -> configItemTempBeanMap.put(tempBean.getConfigItemName(), tempBean));
        StringBuffer buffer = new StringBuffer();
        configItemTempBeanMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(orderedBean -> buffer.append((String)orderedBean.getKey()).append(((MsConfigItemTempBean)orderedBean.getValue()).getConfigItemValue()));
        return DigestUtils.md5Hex((String)buffer.toString());
    }

    private boolean queryInvoiceConfigRuleExists(MsConfigBean msConfigBean) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = cfgConfigExample.createCriteria();
        criteria.andConfigTypeEqualTo(Byte.valueOf(msConfigBean.getConfigType().byteValue()));
        if (msConfigBean.getConfigType().equals(ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType())) {
            String invoiceType = msConfigBean.getInvoiceType();
            criteria.andInvoiceTypeEqualTo(invoiceType);
        }
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        String salesbillType = StringUtils.isEmpty((CharSequence)msConfigBean.getSalesbillType()) ? "" : msConfigBean.getSalesbillType();
        criteria.andSalesbillTypeEqualTo(salesbillType);
        criteria.andBusinessBillTypeEqualTo(msConfigBean.getBusinessBillType());
        if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(msConfigBean.getBusinessBillType())) {
            Long sellerGroupId = msConfigBean.getSellerGroupId();
            criteria.andSellerGroupIdEqualTo(sellerGroupId);
            String sellerTaxNo = msConfigBean.getSellerTaxNo();
            criteria.andSellerTaxNoEqualTo(sellerTaxNo == null ? "" : sellerTaxNo);
            Long purchaserGroupId = msConfigBean.getPurchaserGroupId();
            criteria.andPurchaserGroupIdEqualTo(Long.valueOf(purchaserGroupId == null ? 0L : purchaserGroupId));
            if (null != purchaserGroupId && purchaserGroupId > 0L) {
                String purchaserTaxNo = msConfigBean.getPurchaserTaxNo();
                criteria.andPurchaserTaxNoEqualTo(purchaserTaxNo == null ? "" : purchaserTaxNo);
            }
        } else {
            Long purchaserGroupId = msConfigBean.getPurchaserGroupId();
            criteria.andPurchaserGroupIdEqualTo(purchaserGroupId);
            String purchaserTaxNo = msConfigBean.getPurchaserTaxNo();
            criteria.andPurchaserTaxNoEqualTo(purchaserTaxNo == null ? "" : purchaserTaxNo);
            Long sellerGroupId = msConfigBean.getSellerGroupId();
            criteria.andSellerGroupIdEqualTo(Long.valueOf(sellerGroupId == null ? 0L : sellerGroupId));
            if (null != sellerGroupId && sellerGroupId > 0L) {
                String sellerTaxNo = msConfigBean.getSellerTaxNo();
                criteria.andSellerTaxNoEqualTo(sellerTaxNo == null ? "" : sellerTaxNo);
            }
        }
        return this.cfgConfigDao.countByExample(cfgConfigExample) > 0L;
    }

    private Integer getOffset(MsConfigQueryRequest msConfigBean) {
        Integer pageNo = msConfigBean.getPageNo();
        Integer pageSize = msConfigBean.getPageSize();
        if (pageNo == null || pageNo == 0) {
            pageNo = 1;
        }
        if (pageSize == null || pageSize == 0) {
            pageSize = 10;
        }
        return (pageNo - 1) * pageSize;
    }

    private MsConfigBean fillCompanyInfo(MsConfigBean msConfigBean) {
        GroupModel groupModel;
        String sellerTaxNo = msConfigBean.getSellerTaxNo();
        String purchaserTaxNo = msConfigBean.getPurchaserTaxNo();
        if (!StringUtils.isEmpty((CharSequence)sellerTaxNo)) {
            CompanyModel sellerCompany = this.companyInfoQuery(sellerTaxNo);
            msConfigBean.setSellerNo(String.valueOf(sellerCompany.getCompanyId()));
            msConfigBean.setSellerName(sellerCompany.getCompanyName());
            groupModel = this.groupInfoQueryById(sellerCompany.getCompanyId());
            msConfigBean.setSellerGroupId(Long.valueOf(groupModel == null ? 0L : groupModel.getGroupId()));
        }
        if (!StringUtils.isEmpty((CharSequence)purchaserTaxNo)) {
            CompanyModel purchaserCompany = this.companyInfoQuery(purchaserTaxNo);
            msConfigBean.setPurchaserNo(String.valueOf(purchaserCompany.getCompanyId()));
            msConfigBean.setPurchaserName(purchaserCompany.getCompanyName());
            groupModel = this.groupInfoQueryById(purchaserCompany.getCompanyId());
            msConfigBean.setPurchaserGroupId(Long.valueOf(groupModel == null ? 0L : groupModel.getGroupId()));
        }
        return msConfigBean;
    }

    private CompanyModel companyInfoQuery(String taxNo) {
        SearchCompanyListRequest searchCompanyListRequest = new SearchCompanyListRequest();
        searchCompanyListRequest.setDataType(SearchCompanyListRequest.DataTypeEnum.TAXNUM);
        searchCompanyListRequest.setDataValue(taxNo);
        searchCompanyListRequest.setRid(UUID.randomUUID().toString());
        searchCompanyListRequest.setAppid("config-service");
        SearchCompanyListResponse searchCompanyListResponse = null;
        try {
            searchCompanyListResponse = this.companyApiClient.searchCompanyList(searchCompanyListRequest);
            if (searchCompanyListResponse == null || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)searchCompanyListResponse.getResult())) {
                logger.error("\u672a\u67e5\u8be2\u5230\u516c\u53f8\u4fe1\u606f\uff0c\u5f53\u524d\u7a0e\u53f7\u4e3a{}", (Object)taxNo);
                throw new CompanyQueryException(taxNo);
            }
        }
        catch (Exception exception) {
            logger.error("\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)exception);
            throw new ThridPartyInvokeException("companyClient");
        }
        return (CompanyModel)searchCompanyListResponse.getResult().get(0);
    }

    private GroupModel groupInfoQueryById(Long companyId) {
        GetGroupInfoRequest getGroupInfoRequest = new GetGroupInfoRequest();
        getGroupInfoRequest.setDataType(GetGroupInfoRequest.DataTypeEnum.COMPANYID);
        getGroupInfoRequest.setDataValue(String.valueOf(companyId));
        getGroupInfoRequest.setRid(UUID.randomUUID().toString());
        getGroupInfoRequest.setAppid("config-service");
        GetGroupInfoResponse getGroupInfoResponse = null;
        try {
            getGroupInfoResponse = this.groupApiClient.getGroupInfo(getGroupInfoRequest);
            if (getGroupInfoResponse == null || getGroupInfoResponse.getResult() == null) {
                throw new CompanyQueryException(String.valueOf(companyId));
            }
        }
        catch (Exception exception) {
            throw new ThridPartyInvokeException("groupClient");
        }
        return getGroupInfoResponse.getResult();
    }

    private boolean checkTmpInvoiceInfo(List<MsConfigItemTempBean> list, String invoiceType, String sellerTaxNo, Integer configType) {
        List msConfigItemBeans = list.stream().filter(Objects::nonNull).map(entry -> ConfigItemEntityTranslator.convertFromMsConfigItemTempBean((MsConfigItemTempBean)entry)).collect(Collectors.toList());
        return this.checkConfigItem(msConfigItemBeans, invoiceType, sellerTaxNo, configType);
    }

    private boolean checkConfigItem(List<MsConfigItemBean> msConfigItemBeans, String invoiceTypeStr, String sellerTaxNo, Integer configType) {
        logger.info("checkConfigItem msConfigItemBeans ======{}", (Object)JsonUtils.writeObjectToFastJson(msConfigItemBeans));
        logger.info("checkConfigItem invoiceTypeStr ======{}", (Object)JsonUtils.writeObjectToFastJson((Object)invoiceTypeStr));
        logger.info("checkConfigItem sellerTaxNo ======{}", (Object)JsonUtils.writeObjectToFastJson((Object)sellerTaxNo));
        InvoiceSplitrRuleDTO invoiceSplitrRuleDTO = new InvoiceSplitParser().parse(msConfigItemBeans);
        MsConfigBean msConfigBean = new MsConfigBean();
        msConfigBean.setConfigType(configType);
        msConfigBean.setInvoiceType(invoiceTypeStr);
        msConfigBean.setSellerTaxNo(sellerTaxNo);
        this.checkLimitAmt(msConfigBean, invoiceSplitrRuleDTO.getInvoiceLimit().toString());
        logger.info("checkLimitAmt end ======");
        Integer invoiceMaxRow = invoiceSplitrRuleDTO.getInvoiceItemMaxRow();
        Integer salesListMaxRow = invoiceSplitrRuleDTO.getSalesListMaxRow();
        String saleListOpt = invoiceSplitrRuleDTO.getSaleListOption();
        String taxDeviceType = invoiceSplitrRuleDTO.getTaxDeviceType();
        logger.info("invoiceTypeStr================{}", (Object)invoiceTypeStr);
        InvoiceType invoiceType = InvoiceType.fromValue((String)invoiceTypeStr);
        logger.info("checkConfigItem invoiceType:{}, saleListOpt:{}, invoiceMaxRow:{}, salesListMaxRow:{}", new Object[]{invoiceType.value(), saleListOpt, invoiceMaxRow, salesListMaxRow});
        if (invoiceType == InvoiceType.ELECTRONIC) {
            if (SalesListPrintEnum.NOT_PRINT_SALES_LIST.getSalesListOpt().equals(saleListOpt)) {
                if (invoiceMaxRow != 5 && invoiceMaxRow != 8) {
                    throw new InvoiceSplitConfigException("\u7535\u5b50\u53d1\u7968\uff0c\u7968\u9762\u6700\u5927\u884c\u6570\u53ea\u5141\u8bb8\u586b\u51995\u6216\u80058");
                }
            } else {
                if (invoiceMaxRow != 0 && invoiceMaxRow != 5 && invoiceMaxRow != 8) {
                    throw new InvoiceSplitConfigException("\u7535\u7968\u62c6\u7968\u89c4\u5219\uff0c\u6253\u5370\u9500\u8d27\u6e05\u5355\u9009\u9879\uff0c\u7968\u9762\u6700\u5927\u884c\u6570\u53ea\u80fd\u662f 0\u30015\u62168 ");
                }
                if (salesListMaxRow <= 0 || salesListMaxRow >= 100) {
                    throw new InvoiceSplitConfigException("\u7535\u7968\u62c6\u7968\u89c4\u5219\uff0c\u6253\u5370\u9500\u8d27\u6e05\u5355\u9009\u9879\uff0c\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570\u53ea\u80fd\u662f 1\u81f399\u884c");
                }
            }
        } else if (invoiceType == InvoiceType.NORMAL || invoiceType == InvoiceType.SPECIAL) {
            if (SalesListPrintEnum.NOT_PRINT_SALES_LIST.getSalesListOpt().equals(saleListOpt)) {
                if (invoiceMaxRow < 1 || invoiceMaxRow > 8) {
                    throw new InvoiceSplitConfigException("\u666e\u7968/\u4e13\u7968\u62c6\u7968\u89c4\u5219\uff0c\u4e0d\u6253\u5370\u9500\u8d27\u6e05\u5355\u9009\u9879\uff0c\u7968\u9762\u6700\u5927\u884c\u6570\u53ea\u80fd\u662f 1 \u81f38");
                }
            } else {
                if (invoiceMaxRow < 0 || invoiceMaxRow > 8) {
                    throw new InvoiceSplitConfigException("\u666e\u7968/\u4e13\u7968\u62c6\u7968\u89c4\u5219\uff0c\u6253\u5370\u9500\u8d27\u6e05\u5355\u9009\u9879\uff0c\u7968\u9762\u6700\u5927\u884c\u6570\u53ea\u80fd\u662f 0\u81f38");
                }
                if (StringUtils.equals((CharSequence)taxDeviceType, (CharSequence)"1") || StringUtils.equals((CharSequence)taxDeviceType, (CharSequence)"3")) {
                    if (salesListMaxRow < 0 || salesListMaxRow > 10000) {
                        throw new InvoiceSplitConfigException("\u666e\u7968/\u4e13\u7968\u62c6\u7968\u89c4\u5219\uff0c\u822a\u4fe1\u7a0e\u63a7\u8bbe\u5907\u4e2d\uff0c\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570\u53ea\u80fd\u662f 0 \u81f310000");
                    }
                } else if ((StringUtils.equals((CharSequence)taxDeviceType, (CharSequence)"2") || StringUtils.equals((CharSequence)taxDeviceType, (CharSequence)"4")) && (salesListMaxRow < 0 || salesListMaxRow > 3000)) {
                    throw new InvoiceSplitConfigException("\u666e\u7968/\u4e13\u7968\u62c6\u7968\u89c4\u5219\uff0c\u767e\u65fa\u7a0e\u63a7\u8bbe\u5907\u4e2d\uff0c\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570\u53ea\u80fd\u662f 0 \u81f33000");
                }
            }
        }
        return true;
    }

    private boolean checkBusinessConfig(MsConfigBean msConfigBean) {
        ConfigTypeEnum configTypeEnum = ConfigTypeEnum.of((Integer)msConfigBean.getConfigType());
        switch (1.$SwitchMap$com$xforceplus$seller$config$client$constant$ConfigTypeEnum[configTypeEnum.ordinal()]) {
            case 1: {
                return this.checkInvoiceSplitConfig(msConfigBean);
            }
            case 5: {
                return this.checkInvoiceUserConfig(msConfigBean);
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    private boolean checkInvoiceSplitConfig(MsConfigBean msConfigBean) {
        Integer configType = msConfigBean.getConfigType();
        String invoiceTypeStr = msConfigBean.getInvoiceType();
        ConfigTypeEnum configTypeEnum = ConfigTypeEnum.getConfigTypeByValue((Integer)configType);
        List msConfigItemBeans = msConfigBean.getItemList();
        if (configTypeEnum == ConfigTypeEnum.SPLIT_CONFIG_TYPE) {
            return this.checkConfigItem(msConfigItemBeans, invoiceTypeStr, msConfigBean.getSellerTaxNo(), msConfigBean.getConfigType());
        }
        return true;
    }

    private boolean checkInvoiceUserConfig(MsConfigBean msConfigBean) {
        List msConfigItemBeanList = msConfigBean.getItemList();
        logger.info("checkInvoiceUserConfig---msConfigItemBeanList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigItemBeanList));
        if (CollectionUtils.isEmpty((Collection)msConfigItemBeanList)) {
            throw new ConfigCreateException("\u7968\u9762\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        MsMataDataQueryRequest msMataDataQueryRequest = new MsMataDataQueryRequest();
        msMataDataQueryRequest.setObjCode("invoiceMemberInfoConfig");
        msMataDataQueryRequest.setObjType(msConfigBean.getSalesbillType());
        List cfgBusinessObjMetadataEntityList = this.configMetaDataService.queryTemplateMetaDataList(msMataDataQueryRequest);
        if (CollectionUtils.isEmpty((Collection)cfgBusinessObjMetadataEntityList)) {
            throw new ConfigCreateException("\u7968\u9762\u4eba\u5458\u6821\u9a8c\u4fe1\u606f\u52a0\u8f7d\u5931\u8d25.");
        }
        HashMap validateFieldLengthMap = Maps.newHashMap();
        cfgBusinessObjMetadataEntityList.forEach(item -> validateFieldLengthMap.put(item.getFieldName(), item.getFieldLength()));
        logger.info("checkInvoiceUserConfig---validateFieldLengthMap:{}", (Object)JsonUtils.writeObjectToFastJson((Object)validateFieldLengthMap));
        for (MsConfigItemBean msConfigItemBean : msConfigItemBeanList) {
            Integer fieldLength = (Integer)validateFieldLengthMap.get(msConfigItemBean.getConfigItemName());
            fieldLength = fieldLength == null ? 0 : fieldLength;
            if (CollectionUtils.isEmpty((Collection)msConfigItemBean.getConfigItemValue())) {
                throw new ConfigCreateException("\u7968\u9762\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a.");
            }
            String fieldValue = (String)msConfigItemBean.getConfigItemValue().get(0);
            logger.info("checkInvoiceUserConfig---fieldName:{},fieldValue:{}, length:{}, validateLength:{}", new Object[]{msConfigItemBean.getConfigItemName(), fieldValue.length(), fieldValue, fieldLength});
            if (!StringUtils.isEmpty((CharSequence)fieldValue) && fieldValue.length() <= fieldLength) continue;
            throw new ConfigCreateException("\u7968\u9762\u4eba\u5458\u4fe1\u606f\u3010" + fieldValue + "\u3011\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e" + fieldLength);
        }
        return true;
    }

    private boolean checkConfigItemRequired(MsConfigBean msConfigBean) {
        List unRequiredFiledList = this.unRequiredFiledList();
        List msConfigItemBeanList = msConfigBean.getItemList();
        for (MsConfigItemBean msConfigItemBean : msConfigItemBeanList) {
            String fieldName = msConfigItemBean.getConfigItemName();
            List itemValue = msConfigItemBean.getConfigItemValue();
            if (unRequiredFiledList.contains(fieldName) || !CollectionUtils.isEmpty((Collection)itemValue)) continue;
            String configItemDisplayName = msConfigItemBean.getConfigItemDisplayName();
            if (StringUtils.isEmpty((CharSequence)configItemDisplayName)) {
                if ("splitFiledList".equals(fieldName)) {
                    configItemDisplayName = "\u62c6\u5206\u5b57\u6bb5";
                } else if ("invoiceRemarkFiledList".equals(fieldName)) {
                    configItemDisplayName = "\u5907\u6ce8\u5b57\u6bb5";
                }
            }
            if (StringUtils.isEmpty((CharSequence)configItemDisplayName)) {
                configItemDisplayName = "\u914d\u7f6e\u9879 \u4e0d\u80fd\u4e3a\u7a7a.";
            }
            ConfigItemRequiredException configItemRequiredException = new ConfigItemRequiredException();
            String message = String.format(configItemRequiredException.getMessage(), configItemDisplayName);
            throw new ConfigItemRequiredException(message);
        }
        return true;
    }

    private List<String> unRequiredFiledList() {
        CfgTemplateObjExample cfgTemplateObjExample = new CfgTemplateObjExample();
        cfgTemplateObjExample.createCriteria().andTemplateObjCodeEqualTo("unRequiredFiledsList");
        List cfgTemplateObjEntities = this.cfgTemplateObjDao.selectByExample(cfgTemplateObjExample);
        if (CollectionUtils.isEmpty((Collection)cfgTemplateObjEntities)) {
            return Lists.newArrayList();
        }
        CfgTemplateObjEntity cfgTemplateObjEntity = (CfgTemplateObjEntity)cfgTemplateObjEntities.get(0);
        Long busObjId = cfgTemplateObjEntity.getTemplateObjId();
        CfgTemplateObjMetadataExample cfgTemplateObjMetadataExample = new CfgTemplateObjMetadataExample();
        cfgTemplateObjMetadataExample.createCriteria().andBusinessObjIdEqualTo(busObjId);
        List cfgTemplateObjMetadataEntities = this.cfgTemplateObjMetadataDao.selectByExample(cfgTemplateObjMetadataExample);
        if (CollectionUtils.isEmpty((Collection)cfgTemplateObjMetadataEntities)) {
            return Lists.newArrayList();
        }
        return cfgTemplateObjMetadataEntities.stream().filter(Objects::nonNull).map(entry -> entry.getFieldName()).collect(Collectors.toList());
    }

    private boolean checkConfigName(MsConfigBean msConfigBean, Long groupId) {
        String configName = msConfigBean.getConfigName();
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        cfgConfigExample.createCriteria().andConfigNameEqualTo(configName).andConfigTypeEqualTo(Byte.valueOf(msConfigBean.getConfigType().byteValue())).andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue())).andBusinessBillTypeEqualTo(BusinessSalesBillTypeEnum.AP.getBusinessSalesBillType()).andPurchaserGroupIdEqualTo(groupId);
        CfgConfigExample cfgConfigExampleAR = new CfgConfigExample();
        CfgConfigExample.Criteria criteriaAR = cfgConfigExampleAR.createCriteria();
        criteriaAR.andConfigNameEqualTo(configName);
        criteriaAR.andConfigTypeEqualTo(Byte.valueOf(msConfigBean.getConfigType().byteValue()));
        criteriaAR.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        criteriaAR.andBusinessBillTypeEqualTo(BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType());
        criteriaAR.andSellerGroupIdEqualTo(groupId);
        cfgConfigExample.or(criteriaAR);
        long count = this.cfgConfigDao.countByExample(cfgConfigExample);
        if (count > 0L) {
            throw new ConfigNameRepeatException();
        }
        if (ConfigTypeEnum.INVOICE_USER_CONFIG_TYPE.getConfigType().intValue() == msConfigBean.getConfigType().intValue() || ConfigTypeEnum.INVOICE_CONFIG_TYPE.getConfigType().intValue() == msConfigBean.getConfigType().intValue()) {
            CfgConfigExample example = new CfgConfigExample();
            example.createCriteria().andSalesbillTypeEqualTo(msConfigBean.getSalesbillType()).andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue())).andConfigTypeEqualTo(Byte.valueOf(msConfigBean.getConfigType().byteValue())).andSellerTaxNoEqualTo(msConfigBean.getSellerTaxNo()).andBusinessBillTypeEqualTo(msConfigBean.getBusinessBillType()).andPurchaserTaxNoEqualTo(msConfigBean.getPurchaserTaxNo());
            long countConfig = this.cfgConfigDao.countByExample(example);
            if (countConfig > 0L) {
                throw new InvoiceFaceConfigRepeatException();
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkLimitAmt(MsConfigBean tmp, String value) {
        logger.info("checkLimitAmt--tmp:{} value:{}", (Object)tmp, (Object)value);
        if (!CommonTools.isEmpty((String)tmp.getSellerTaxNo()) && ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType().intValue() == tmp.getConfigType().intValue()) {
            BigDecimal decimalValue;
            CompanyModel companyModel = this.companyInfoQuery(tmp.getSellerTaxNo());
            BigDecimal limit = BigDecimal.ZERO;
            if (InvoiceType.NORMAL.value().equals(tmp.getInvoiceType())) {
                if (CommonTools.isEmpty((String)companyModel.getCquota())) {
                    logger.info("\u5f53\u524d\u9500\u65b9\u516c\u53f8\uff0c\u666e\u7968\u6ca1\u6709\u914d\u7f6e\u9650\u989d");
                    throw new RuntimeException("\u5f53\u524d\u9500\u65b9\u516c\u53f8\uff0c\u666e\u7968\u6ca1\u6709\u914d\u7f6e\u9650\u989d");
                }
                limit = new BigDecimal(companyModel.getCquota());
            } else if (InvoiceType.SPECIAL.value().equals(tmp.getInvoiceType())) {
                if (CommonTools.isEmpty((String)companyModel.getSquota())) {
                    logger.info("\u5f53\u524d\u9500\u65b9\u516c\u53f8\uff0c\u4e13\u7968\u6ca1\u6709\u914d\u7f6e\u9650\u989d");
                    throw new RuntimeException("\u5f53\u524d\u9500\u65b9\u516c\u53f8\uff0c\u4e13\u7968\u6ca1\u6709\u914d\u7f6e\u9650\u989d");
                }
                limit = new BigDecimal(companyModel.getSquota());
            } else if (InvoiceType.ELECTRONIC.value().equals(tmp.getInvoiceType())) {
                if (CommonTools.isEmpty((String)companyModel.getCeQuota())) {
                    logger.info("\u5f53\u524d\u9500\u65b9\u516c\u53f8\uff0c\u7535\u7968\u6ca1\u6709\u914d\u7f6e\u9650\u989d");
                    throw new RuntimeException("\u5f53\u524d\u9500\u65b9\u516c\u53f8\uff0c\u7535\u7968\u6ca1\u6709\u914d\u7f6e\u9650\u989d");
                }
                limit = new BigDecimal(companyModel.getCeQuota());
            } else if (InvoiceType.NORMAL_ROLL.value().equals(tmp.getInvoiceType())) {
                if (CommonTools.isEmpty((String)companyModel.getJuQuota())) {
                    logger.info("\u5f53\u524d\u9500\u65b9\u516c\u53f8\uff0c\u5377\u7968\u6ca1\u6709\u914d\u7f6e\u9650\u989d");
                    throw new RuntimeException("\u5f53\u524d\u9500\u65b9\u516c\u53f8\uff0c\u5377\u7968\u6ca1\u6709\u914d\u7f6e\u9650\u989d");
                }
                limit = new BigDecimal(companyModel.getJuQuota());
            } else if (InvoiceType.VEHICLE.value().equals(tmp.getInvoiceType())) {
                logger.info("\u4e00\u671f\u6ca1\u6709");
            }
            if ((InvoiceType.NORMAL.value().equals(tmp.getInvoiceType()) || InvoiceType.SPECIAL.value().equals(tmp.getInvoiceType()) || InvoiceType.ELECTRONIC.value().equals(tmp.getInvoiceType()) || InvoiceType.NORMAL_ROLL.value().equals(tmp.getInvoiceType())) && (decimalValue = new BigDecimal(value)).compareTo(limit) == 1) {
                logger.info("\u5f00\u7968\u9650\u989d\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d\u9500\u65b9\u516c\u53f8\u7684\u5f00\u7968\u9650\u989d\uff0c\u9650\u989d\u4e3a\u3010" + limit.toPlainString() + "\u3011\u5b9e\u9645\u4f20\u5165\u503c\u3010" + decimalValue.toPlainString() + "\u3011");
                throw new RuntimeException("\u5f00\u7968\u9650\u989d\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d\u9500\u65b9\u516c\u53f8\u7684\u5f00\u7968\u9650\u989d\uff0c\u9650\u989d\u4e3a\u3010" + limit.toPlainString() + "\u3011\u5b9e\u9645\u4f20\u5165\u503c\u3010" + decimalValue.toPlainString() + "\u3011");
            }
        }
    }
}

